/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.jface.resource;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceRegistryInfo;

public final class RegistryContainerInfo
extends ObjectInfo {
    public static RegistryContainerInfo get(JavaInfo root) throws Exception {
        RegistryContainerInfo container = RegistryContainerInfo.findContainer(root);
        if (container != null) {
            return container;
        }
        container = new RegistryContainerInfo();
        root.addChild((ObjectInfo)container);
        return container;
    }

    public static <T extends ResourceRegistryInfo> List<T> getRegistries(JavaInfo root, Class<T> componentClass) throws Exception {
        RegistryContainerInfo container = RegistryContainerInfo.findContainer(root);
        if (container != null) {
            return container.getChildren(componentClass);
        }
        return Collections.emptyList();
    }

    public static ResourceRegistryInfo getRegistry(JavaInfo root, ASTNode node) throws Exception {
        RegistryContainerInfo container = RegistryContainerInfo.findContainer(root);
        Assert.isNotNull((Object)((Object)container));
        for (ResourceRegistryInfo registry : container.getRegistryChildren()) {
            if (!registry.isRepresentedBy(node)) continue;
            return registry;
        }
        Assert.fail((String)MessageFormat.format(ModelMessages.RegistryContainerInfo_unknownRegistry, root, node));
        return null;
    }

    private static RegistryContainerInfo findContainer(JavaInfo root) {
        for (ObjectInfo child : root.getChildren()) {
            if (!(child instanceof RegistryContainerInfo)) continue;
            return (RegistryContainerInfo)child;
        }
        return null;
    }

    public List<ResourceRegistryInfo> getRegistryChildren() {
        return this.getChildren(ResourceRegistryInfo.class);
    }

    public IObjectPresentation getPresentation() {
        return new DefaultObjectPresentation(this){

            public String getText() throws Exception {
                return ModelMessages.RegistryContainerInfo_jfaceRegistries;
            }

            public Image getIcon() throws Exception {
                return Activator.getImage("components/registry_container.gif");
            }
        };
    }

    public boolean canDelete() {
        return false;
    }

    public void delete() throws Exception {
    }
}

