// Copyright (C) 1999-2002 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Common C++.
//
// The exception is that, if you link the Common C++ library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the Common C++ library code into it.
//
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
//
// This exception applies only to the code released under the
// name Common C++.  If you copy code from other releases into a copy of
// Common C++, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for Common C++, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include <cc++/config.h>
#include <cc++/export.h>
#include <cc++/string.h>
#include <cc++/exception.h>

#if defined(HAVE_EXCEPTION)

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

Exception::Exception(const String& what_arg) throw(): 
  _what(what_arg) 
{ }

Exception::~Exception() throw()
{}

const char *Exception::getString() const 
{
	return _what.c_str();
}

IOException::IOException(const String &what_arg, long systemError) throw() : 
	Exception(what_arg), _systemError(systemError), 
	_systemErrorString(NULL)
{
}

IOException::~IOException() throw()
{
	delete [] _systemErrorString;
}

const char* IOException::getSystemErrorString() const throw()
{
	const uint32 errStrSize = 2048;
	if ( !_systemErrorString )
		_systemErrorString = new char[errStrSize];
#ifndef WIN32
	strerror_r(_systemError, _systemErrorString, errStrSize);
	return _systemErrorString;

#else
	FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, _systemError,
		       MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),
		       _systemErrorString, errStrSize, NULL);
	return _systemErrorString;
#endif
}

#ifdef	CCXX_NAMESPACES
}
#endif

#endif //HAVE_EXCEPTION

/** EMACS **
 * Local variables:
 * mode: c++
 * c-basic-offset: 8
 * End:
 */
