/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    FocusListener focusDelegator;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new MetalComboPopup(this.comboBox);
    }

    protected JButton createArrowButton() {
        MetalComboBoxButton metalComboBoxButton = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        metalComboBoxButton.setMargin(new Insets(0, 1, 1, 3));
        return metalComboBoxButton;
    }

    FocusListener createFocusDelegator() {
        return new FocusDelegator();
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            metalComboBoxButton.setIconOnly(this.comboBox.isEditable());
            metalComboBoxButton.setRequestFocusEnabled(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            this.comboBox.repaint();
        }
    }

    void enabledPropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.arrowButton instanceof MetalComboBoxButton) {
            this.arrowButton.setRequestFocusEnabled(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            this.comboBox.repaint();
        }
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    public void layoutComboBox(Container container, MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        if (this.comboBox.isEditable()) {
            metalComboBoxLayoutManager.superLayout(container);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int n = this.comboBox.getWidth();
            int n2 = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, n - (insets.left + insets.right), n2 - (insets.top + insets.bottom));
        }
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return false;
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.keyListener = this.createKeyListener();
        this.focusListener = this.createFocusListener();
        this.popupKeyListener = this.popup.getKeyListener();
        this.popupMouseListener = this.popup.getMouseListener();
        this.popupMouseMotionListener = this.popup.getMouseMotionListener();
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
        if ((this.focusDelegator = this.createFocusDelegator()) != null) {
            this.comboBox.addFocusListener(this.focusDelegator);
        }
    }

    protected void uninstallListeners() {
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
        if (this.focusDelegator != null) {
            this.comboBox.removeFocusListener(this.focusDelegator);
        }
    }

    protected void removeListeners() {
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void configureEditor() {
        super.configureEditor();
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setRequestFocusEnabled(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            if (this.keyListener != null) {
                this.arrowButton.addKeyListener(this.keyListener);
            }
            if (this.popupKeyListener != null) {
                this.arrowButton.addKeyListener(this.popupKeyListener);
            }
            if (this.focusListener != null) {
                this.arrowButton.addFocusListener(this.focusListener);
            }
            if (this.popupMouseListener != null) {
                this.arrowButton.addMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.addMouseMotionListener(this.popupMouseMotionListener);
            }
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            super.unconfigureArrowButton();
            if (this.keyListener != null) {
                this.arrowButton.removeKeyListener(this.keyListener);
            }
            if (this.popupKeyListener != null) {
                this.arrowButton.removeKeyListener(this.popupKeyListener);
            }
            if (this.focusListener != null) {
                this.arrowButton.removeFocusListener(this.focusListener);
            }
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            Insets insets = metalComboBoxButton.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + metalComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            Insets insets3 = this.comboBox.getInsets();
            if (this.editor instanceof JComponent) {
                Insets insets4 = ((JComponent)this.editor).getInsets();
                dimension.height += insets4.top + insets4.bottom;
            }
            dimension.height += insets.top + insets.bottom;
            dimension.height += insets3.top + insets3.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    JComboBox metalGetComboBox() {
        return this.comboBox;
    }

    JButton getArrowButton() {
        return this.arrowButton;
    }

    boolean isPopupVisible() {
        return super.isPopupVisible(this.comboBox);
    }

    void togglePopup() {
        this.toggleOpenClose();
    }

    Component metalGetEditor() {
        return this.editor;
    }

    JButton metalGetArrowButton() {
        return this.arrowButton;
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void delegateFocus(MouseEvent mouseEvent) {
            if (MetalComboBoxUI.this.metalGetComboBox().isEditable()) {
                MetalComboBoxUI.this.metalGetEditor().requestFocus();
            }
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer(Container container) {
            MetalComboBoxUI.this.layoutComboBox(container, this);
        }

        public void superLayout(Container container) {
            super.layoutContainer(container);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            MetalComboBoxUI.this.metalGetComboBox().setRequestFocusEnabled(true);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                MetalComboBoxUI.this.editablePropertyChanged(propertyChangeEvent);
            } else if (string.equals("enabled")) {
                MetalComboBoxUI.this.enabledPropertyChanged(propertyChangeEvent);
            }
        }
    }

    class FocusDelegator
    extends FocusAdapter {
        FocusDelegator() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (MetalComboBoxUI.this.metalGetComboBox().isEditable()) {
                MetalComboBoxUI.this.metalGetEditor().requestFocus();
            } else {
                MetalComboBoxUI.this.metalGetArrowButton().requestFocus();
            }
        }
    }
}

