/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import sun.awt.Mutex;
import sun.awt.SunToolkit;

public abstract class SunDragSourceContextPeer
implements DragSourceContextPeer,
Runnable {
    protected DragSource dragSource;
    protected Component component;
    protected DragGestureEvent trigger;
    protected Cursor cursor;
    protected int actions;
    protected long nativeCtxt;
    protected DragSourceContext dragSourceContext;
    static final int DISPATCH_NONE = 0;
    static final int DISPATCH_ENTER = 1;
    static final int DISPATCH_MOTION = 2;
    static final int DISPATCH_CHANGED = 3;
    static final int DISPATCH_EXIT = 4;
    static final int DISPATCH_FINISH = 5;
    protected int messagePending = 0;
    protected int currentA;
    protected int currentDA;
    protected int currentMods;
    protected boolean currentSuccess;
    protected int currentOperations;
    protected Mutex syncLock = new Mutex();

    public SunDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        this.trigger = dragGestureEvent;
        this.component = dragGestureEvent.getComponent();
        this.dragSource = dragGestureEvent.getDragSource();
    }

    public abstract void startDrag(DragSourceContext var1, Cursor var2, Image var3, Point var4) throws InvalidDnDOperationException;

    public Cursor getCursor() {
        return this.cursor;
    }

    public abstract void setCursor(Cursor var1) throws InvalidDnDOperationException;

    public void transferablesFlavorsChanged() {
    }

    public void run() {
        this.syncLock.lock();
        int n = this.messagePending;
        this.syncLock.unlock();
        switch (n) {
            case 1: {
                this.processEnterMessage();
                break;
            }
            case 3: {
                this.processChangedMessage();
                break;
            }
            case 2: {
                this.processMotionMessage();
                break;
            }
            case 4: {
                this.processExitMessage();
                break;
            }
            case 5: {
                this.processFinishMessage();
            }
        }
        this.syncLock.lock();
        if (this.messagePending != 0) {
            this.messagePending = 0;
            this.quitSecondaryDispatch();
        }
        this.syncLock.unlock();
    }

    private void dragEnter(int n, int n2, int n3) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.currentDA = n;
        this.currentA = n2;
        this.currentMods = n3;
        this.messagePending = 1;
        SunToolkit.executeOnEventHandlerThread(this.component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    private void processEnterMessage() {
        try {
            this.dragSourceContext.dragEnter(new DragSourceDragEvent(this.dragSourceContext, this.currentDA, this.currentA, this.currentMods));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void dragMotion(int n, int n2, int n3) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.currentDA = n;
        this.currentA = n2;
        this.currentMods = n3;
        this.messagePending = 2;
        SunToolkit.executeOnEventHandlerThread(this.component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    private void processMotionMessage() {
        try {
            this.dragSourceContext.dragOver(new DragSourceDragEvent(this.dragSourceContext, this.currentDA, this.currentA, this.currentMods));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void operationChanged(int n, int n2, int n3) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.currentDA = n;
        this.currentA = n2;
        this.currentMods = n3;
        this.messagePending = 3;
        SunToolkit.executeOnEventHandlerThread(this.component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    private void processChangedMessage() {
        try {
            this.dragSourceContext.dropActionChanged(new DragSourceDragEvent(this.dragSourceContext, this.currentDA, this.currentA, this.currentMods));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void dragExit() {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.messagePending = 4;
        SunToolkit.executeOnEventHandlerThread(this.component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    private void processExitMessage() {
        try {
            this.dragSourceContext.dragExit(new DragSourceEvent(this.dragSourceContext));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void dodragDropFinished(boolean bl, int n) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.currentSuccess = bl;
        this.currentOperations = n;
        this.messagePending = 5;
        SunToolkit.executeOnEventHandlerThread(this.component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    private void processFinishMessage() {
        try {
            DragSourceDropEvent dragSourceDropEvent = new DragSourceDropEvent(this.dragSourceContext, this.currentOperations, this.currentSuccess);
            this.dragSourceContext.dragExit(dragSourceDropEvent);
            this.dragSourceContext.dragDropEnd(dragSourceDropEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void startSecondaryDispatch() {
        Thread.yield();
    }

    protected void quitSecondaryDispatch() {
    }
}

