/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License. 
 *
 * The Original Code is ChatZilla
 * 
 * The Initial Developer of the Original Code is
 * Robert Ginda
 * Portions created by Robert Ginda are Copyright (C) 2005 Robert Ginda.
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU Public License (the "GPL"), in which case the
 * provisions of the GPL are applicable instead of those above.
 * If you wish to allow use of your version of this file only
 * under the terms of the GPL and not to allow others to use your
 * version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL.  If you do not delete
 * the provisions above, a recipient may use your version of this
 * file under either the MPL or the GPL.
 *
 * Contributor(s):
 *  Robert Ginda, <rginda@hacksrus`com>, original author
 */

plugin.id = "dice";
plugin.major = 1;
plugin.minor = 2;
plugin.version = plugin.major + "." + plugin.minor;
plugin.description = "Dice roller.  See /help dice.";

plugin.init =
function initPlugin(glob)
{

    plugin.cmdary =
        [["dice", cmdDice, CMD_CONSOLE | CMD_NEED_SRV | CMD_NO_HELP,
         "[<sides> [<count> [<modifier>]]]"]
         ];

    return true;
}

plugin.enable =
function enablePlugin()
{
    client.commandManager.defineCommands(plugin.cmdary);

    client.commandManager.commands["dice"].help =
        "Rolls dice and announces the results on the current channel or " +
        "query view.";

    return true;
}

plugin.disable =
function disablePlugin()
{
    client.commandManager.removeCommands(plugin.cmdary);

    return true;
}

function cmdDice(e)
{
    if (!e.channel && !e.user)
    {
        display("This command must be run from a channel or query view",
                MT_ERROR);
        return;
    }

    e.sides = parseInt(e.sides) || 6;
    e.count = parseInt(e.count) || 1;

    if (e.modifier)
        e.modifier = parseInt(e.modifier);

    var ary = new Array();
    var total = 0;

    for (var i = 0; i < e.count; ++i)
    {
        ary[i] = randomRange(1, e.sides);
        total += ary[i];
    }

    total += (e.modifier || 0);
    if (e.modifier && e.modifier > 0)
        e.modifier = "+" + e.modifier;

    var str = "rolls a d" + e.sides;

    if (e.count > 1)
    {
        str += " " + e.count + " times: ";
        str += ary.join(", ");
        str += e.modifier ? ", total (" + e.modifier + "): " : ", total: ";
        str += total;
    }
    else
    {
        str += ": " + ary[0];
    }
    
    var replyTo = e.channel || e.user;
    replyTo.dispatch("me", { action: str });
}
