// core functions for MinimizeToTray
  
if (!('extensions' in window))
    window.extensions = new Array();

if (!('mook' in window.extensions))
    window.extensions.mook = new Array();

if (!('minimizetotray' in window.extensions.mook))
    window.extensions.mook.minimizetotray = 
    function(){
        // this is a stub only
        throw Components.results.NS_ERROR_ABORT;
    };

///// constants
    window.extensions.mook.minimizetotray
.k_contractid_windowWatcher =
    '@minimizetotray.mozdev.org/minimizetotray/window-watcher;1';

    window.extensions.mook.minimizetotray
.k_contractid_windowHider =
    '@minimizetotray.mozdev.org/minimizetotray/window-hider;1';

    window.extensions.mook.minimizetotray
.k_pref_prefix =
    'extensions.minimizetotray.';

    window.extensions.mook.minimizetotray
.k_xul_prefix =
    'extensions.mook.minimizetotray.';

///// component handles
    window.extensions.mook.minimizetotray
.m_windowWatcher = null;

    window.extensions.mook.minimizetotray
.m_windowHider = null;

    window.extensions.mook.minimizetotray
.m_prefs = null;

    window.extensions.mook.minimizetotray
.m_stringBundleService = 
  Components.classes["@mozilla.org/intl/stringbundle;1"]
	          .getService(Components.interfaces['nsIStringBundleService']);

    window.extensions.mook.minimizetotray
.m_stringsCommon = 
  window.extensions.mook.minimizetotray
        .m_stringBundleService.createBundle(
        	"chrome://minimizetotray/locale/common.properties"
        );


///// global variables
    window.extensions.mook.minimizetotray
.m_isTurboMode = false;
 
    window.extensions.mook.minimizetotray
.m_isHidden = false;

    window.extensions.mook.minimizetotray
.m_isSuppressed = false;

 
/////methods
    window.extensions.mook.minimizetotray
.init = 
function () {

    // because |this| is |window|, where the event fired,
    // not |window.extensions.mook.minimizetotray|
    var self = window.extensions.mook.minimizetotray;
    
    // check to be sure that both app-neutral and app-specific parts
    // of the script has been loaded
    if (!('m_bLoadedCore' in self) || (!self.m_bLoadedCore) ||
        !('m_bLoadedApp' in self) || (!self.m_bLoadedApp)) {
        window.setTimeout(
            self.init, 10);
        return;
    }
         
    // this needs to be triggered from a new event
    // due to bug 174320
    // XXX Mook: remove workaround once we no longer support Firefox 1.0 &c
    //           (so, probably not any time soon)
    window.setTimeout(
        function() {
            window.removeEventListener(
                "load", 
                window.extensions.mook.minimizetotray.init, true);
        }, 
        0);
    
    // we get an extra fire because the remove listener hasn't fired
    // so we just ignore the inconsistency - pretend it never happened
    if (self.m_prefs)
        return;
        //throw Components.results.NS_ERROR_ALREADY_INITIALIZED;
    
    
    self.m_prefs =
        Components.classes["@mozilla.org/preferences-service;1"]
            .getService(Components.interfaces.nsIPrefBranch);
    
    self.noBinaryComponentWarning();

    self.m_windowWatcher =
        Components.classes[self.k_contractid_windowWatcher]
            .createInstance(Components.interfaces.trayIWindowWatcher);
     self.m_windowWatcher.init(
        self.getBaseWindow(window),
        self.windowWatcherCallback);
                                 
    //self.turboModeTest();
};

    window.extensions.mook.minimizetotray
.windowWatcherCallback = 
function( aEvent, aParam, aKeyMask, aData1, aData2) {
    // note that |this| is the function itself
    var self = window.extensions.mook.minimizetotray;
    var iface = Components.interfaces.trayIWindowCallback;
    var rv = false;
    switch (aEvent) {
        case iface.EVENT_WINDOW_MINIMIZE:
            // window is trying to minimize normally
            try {
                if (!self.m_prefs.getBoolPref(self.k_pref_prefix + 'always'))
                    break;
            } catch (ex) {
                // we managed to lose the default pref 
                // assume not set, hence keep going (no break)
            }
            if (self.m_isSuppressed)
                // this is part of a hide, don't recurse
                break;
            if (aKeyMask & iface.KEY_CONTROL)
                self.minimizeAll();
            else
                self.minimizeWindow();
            rv = true;
            break;
        case iface.EVENT_WINDOW_ACTIVATE:
            // this window is being forcibly shown
            self.restore();
            break;
        case iface.EVENT_WINDOW_CLOSE:
            //See if the window has a menubar.  This is important because
            //if the window does not have a way to select File-Exit because the menu
            //bar is missing, then there isn't an easy way to close that window
            //So, the workaround is to normally close windows that whose menubars are hidden.              
            if (document.documentElement.getAttribute("chromehidden").indexOf("menubar") == -1) {                        
                //see if the user wishes to minimize to the tray instead of closing.
                //this should NOT fire if File->Exit is run by the user.  It should
                //fire if the user typed Alt+F4 to close the window.  This does NOT include 
                //the event when the user clicked on the close button.  (To make things more confusing
                //I believe Mozilla 1.7.8 handled both Alt+F4 and the left click on the close button here)
                try {
                    if (self.m_prefs.getBoolPref(self.k_pref_prefix + 'minimize-on-close')) {
                        self.minimizeWindow();
                        rv = true;
                    }                        
                    break;
                } catch (ex) {
                    // we managed to lose the default pref 
                    // assume not set.  
                }       
            }        	
            break;                       
        case iface.EVENT_MOUSEDOWN_RIGHT:                
            if (iface.PARAM_MOUSE_MINIMIZE == aParam) {
                if (aKeyMask & iface.KEY_CONTROL)
                    self.minimizeAll();
                else
                    self.minimizeWindow();
                rv = true;
            }
            break;
        case iface.EVENT_MOUSEDOWN_MIDDLE:
            if (iface.PARAM_MOUSE_MINIMIZE == aParam) {
                self.minimizeAll();
                rv = true;
            }
            break;
        case iface.EVENT_MOUSEDOWN_LEFT: 
                   	
            if (iface.PARAM_MOUSE_CLOSE == aParam) {
            //Handle when the user attempts to close the window by left clicking on the close button.
            //This does NOT cover the Alt+F4 case of closing a window.            
                try {
                    if (!self.m_prefs.getBoolPref(self.k_pref_prefix + 'minimize-on-close'))
                        break;
                } catch (ex) {
                    // we managed to lose the default pref 
                    // assume not set.  Break because we don't
                    // want to minimize to tray if don't have any saved pref
                    //telling us to.
                    break;
                }

                if (aKeyMask & iface.KEY_CONTROL) {                
                    self.minimizeAll();
                    rv = true;
                }
                //See if the window has a menubar.  This is important because
                //if the window does not have a way to select File-Exit because the menu
                //bar is missing, then there isn't an easy way to close that window
                //So, the workaround is to normally close windows that whose menubars are hidden.
                else if (document.documentElement.getAttribute("chromehidden").indexOf("menubar") == -1) {                    
                    self.minimizeWindow();                                                              
                    rv = true;
                }    
            }
            break;       	            
    }
    return rv;
};

    window.extensions.mook.minimizetotray
.minimizeWindow = 
function() {
    this.noBinaryComponentWarning();
    this.m_isSuppressed = true;
    window.minimize();
    this.m_isSuppressed = false;
    this.restore();
    this.m_windowHider =
        Components.classes[this.k_contractid_windowHider]
            .createInstance(Components.interfaces.trayIWindowHider);
    var baseWindows = [this.getBaseWindow(window)];
    this.m_isHidden = [window];
    this.m_windowHider.minimize(
        baseWindows.length, 
        baseWindows,
        null,
        this.trayCallback);  
};

    window.extensions.mook.minimizetotray
.minimizeAll = 
function() {
    this.noBinaryComponentWarning();
    this.restore();
    this.m_windowHider =
        Components.classes[this.k_contractid_windowHider]
            .createInstance(Components.interfaces.trayIWindowHider);
    var baseWindows = new Array();
    var wm = 
        Components.classes["@mozilla.org/appshell/window-mediator;1"]
            .getService(Components.interfaces.nsIWindowMediator);
    var e = wm.getEnumerator(null);
    var windows = [];
    while (e.hasMoreElements()) {
        var w = e.getNext();
        // don't hide turbo mode hidden windows... :p
        if (!('extensions' in w))
            w.extensions = new Array();
        if (!('mook' in w.extensions))
            w.extensions.mook = new Array();
        if (!('minimizetotray' in w.extensions.mook)) {
            w.extensions.mook.minimizetotray = new Object();
            w.extensions.mook.minimizetotray.m_isHidden = false;
        }
        if (!w.extensions.mook.minimizetotray.m_isHidden) {
        	baseWindows[baseWindows.length] = this.getBaseWindow(w);
        	w.extensions.mook.minimizetotray.m_isHidden = true;
          windows[windows.length] = w;
        	w.extensions.mook.minimizetotray.m_isSuppressed = true;
			    w.minimize();
        	w.extensions.mook.minimizetotray.m_isSuppressed = false;
        }
    } 
    this.m_isHidden = windows;
    var title = null;
    if (baseWindows.length > 1)
        title = this.m_stringsCommon
	                  .formatStringFromName(
	                      "trayTooltipMultiple", 
	                      [baseWindows.length],
	                      1
	                  );
    this.m_windowHider.minimize(
        baseWindows.length, 
        baseWindows,
        title,
        this.trayCallback);
};

    window.extensions.mook.minimizetotray
.restore =
function( ) {
    // need to remove the handle to the windowHider first, because
    // we activate the window when it is restored, thus firing a new
    // JS restore() while we're in the middle of the call to
    // trayIWindowHider::Restore()
    var wh = this.m_windowHider;
    this.m_windowHider = null;
    if (wh) {
        var windows = this.m_isHidden;
        for (var i = 0; i < windows.length; ++i) {
            var w = windows[i];
            // w is a window to be restored
            if (w) {
                w.extensions.mook.minimizetotray.m_isHidden = false;
            }
        }
        wh.restore();
    }
}

    window.extensions.mook.minimizetotray
.getBaseWindow = 
function( win ) {
    var rv;
    try
    {
        var requestor = 
            win.QueryInterface(Components.interfaces.nsIInterfaceRequestor);
        var nav = 
            requestor.getInterface(Components.interfaces.nsIWebNavigation);
        var dsti = 
            nav.QueryInterface(Components.interfaces.nsIDocShellTreeItem);
        var owner = dsti.treeOwner;
        requestor = 
            owner.QueryInterface(Components.interfaces.nsIInterfaceRequestor);
        rv = requestor.getInterface(Components.interfaces.nsIXULWindow);
        rv = rv.docShell;
        rv = rv.QueryInterface(Components.interfaces.nsIDocShell);
        rv = rv.QueryInterface(Components.interfaces.nsIBaseWindow);
    }
    catch (ex)
    {
        rv = null;
        setTimeout(function(){throw ex},0);
        /* ignore no-interface exception */
    }
    return rv;    
};

    window.extensions.mook.minimizetotray
.noBinaryComponentWarning = 
function( ) {
    if (!(
        this.k_contractid_windowWatcher in Components.classes &&
        this.k_contractid_windowHider in Components.classes
        )) {
        // can't find binary component
        var promptService =
            Components.classes['@mozilla.org/embedcomp/prompt-service;1']
                .getService(Components.interfaces.nsIPromptService);
        promptService.alert(
            window,
            "Minimize To Tray - Component Load Error",
            'Cannot find binary component');
        // prevent popping up two warnings
        this.m_windowWatcher = true;
        throw Components.results.NS_ERROR_NOT_AVAILABLE;
    }
};

    window.extensions.mook.minimizetotray
.turboModeTest = function ( ) {
    
    var self = window.extensions.mook.minimizetotray;
    
    var commandLine =
        Components.classes['@mozilla.org/appshell/commandLineService;1']
            .getService(Components.interfaces.nsICmdLineService);

    if (commandLine.getCmdLineValue('-turbo')) {
        
        
        //see if not yet running in turbo mode, and if this is the case, launch a turbo window
        
        //if (!self.m_prefs.getBoolPref(self.k_pref_prefix + 'runningInTurboMode')) {
        //    //we're not running in turbo mode.  Create a window to be used as the turbo tray icon.
        //    window.open("chrome://minimizetotray/content/turbo.xul", "", "chrome,width=600,height=300");
        //    //save value in prefs to tell us we've loaded a turbo window
        //    //(Note, this needed to be saved as a preference rather than a global boolean variable so 
        //    //it can be shared among all windows.  Global variables go out of scope when another xul calls this code.)
        //    self.m_prefs.setBoolBref('runningInTurboMode',1);
        //}
        
        // run in -turbo mode (quicklaunch)
        //create a blank xul window        
        // look for existing -turbo mode windows
               
        //window.alert("self.m_turboWindowLoaded is: " + self.m_turboWindowLoaded + " while window.extensions.mook.minimizetotray.m_turboWindowLoaded is: " + window.extensions.mook.minimizetotray.m_turboWindowLoaded);
        //if (self.m_turboWindowLoaded == false) {
        //    window.alert('creating turbo.xul');
        //   window.open("chrome://minimizetotray/content/turbo.xul", "", "chrome,width=600,height=300");
        //    self.m_turboWindowLoaded = true;
        //    window.alert("m_turboWindowLoaded is now: " + self.m_turboWindowLoaded);          
        //}
        //window.setTimeout(
        //    this.turboMode,
        //    100);
    }
};

    window.extensions.mook.minimizetotray
.showPopup = function ( popup, x, y ) {
//the x and y parameters pass in the x and y location of the mouse click

    // adjust popup position once we know width / height
    popup._minimizetotray_onshown = function(event) {
        var popup = event.target;
        
        // prevent infinite recursion (trips bug 174320)
        popup.removeEventListener(
            "popupshown",
            popup._minimizetotray_onshown,
            true);
        
        var box = popup.popupBoxObject;
        var x = popup.targetX;
        var y = popup.targetY;
        if (x + box.width > screen.width)
            x = popup.targetX - box.width;
        if (y + box.height > screen.height)
            y = popup.targetY - box.height;
        
        // re-show the popup in the right position
        popup.hidePopup();
        document.popupNode = null;
        popup.showPopup(
            document.documentElement,
            x, y,
            "context",
            "", "");
    }
    
    popup.addEventListener(
        "popupshown",
        popup._minimizetotray_onshown,
        true);
    
	//Attempt to show the popup in negatove coordinate land.  
	//Once shown, the addEventListener event will fire
	//and we can then determine the size of the popup so we can
	//correctly redisplay it in the correct spot.
    popup.targetX = x;
    popup.targetY = y;
    popup.showPopup(
        document.documentElement,   // anchoring element
        -999999,                    // x
        -999999,                    // y
        "context",                  // type
        "",                         // popupanchor (ignored)
        "");                        // popupalign (ignored)
};
  
window.addEventListener(    
    "load", 
    window.extensions.mook.minimizetotray.init, 
    true
);

// signal that the core has loaded
window.extensions.mook.minimizetotray.m_bLoadedCore = true;
