/* 
	FILEMANAGER  --  A FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
	Author: Duong Thanh An - dgthanhan@gmail.com (core)
	Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)

	Copyright (C) 2004 Anisolution.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Anisolution.com
	http://www.anisolution.com
	HCMC Vietnam
	Duong Thanh An
	dgthanhan@gmail.com


	$Id: Clipboard.js,v 1.1 2004/11/27 11:58:05 thanh.an Exp $

*/

//A Shared Clipboard implementation for File Manager

var clipboard = null;
var COPY = 1;
var CUT = 2;
function getMainWindow(){
	return getMainWindowImpl(window);
}
	function getMainWindowImpl(win) {
		if(!win) return null;
		if(win.isMainWindow) return win;
		if(win == win.opener) return win;
		return getMainWindowImpl(win.opener);
	}
function getClipboardObject() {
	var w = getMainWindow();
	if(!w.clipboard) w.clipboard = new Object();
	return w.clipboard;
}
function copyToClipboard(s) {
	var o = getClipboardObject();
	o.action = COPY;
	o.content = s;
}
function cutToClipboard(s){
	var o = getClipboardObject();
	o.action = CUT;
	o.content = s;
}
function emptyClipboard() {
	getMainWindow().clipboard = null;
}
function isClipboardEmpty() {
	if(getMainWindow().clipboard) return false;
	return true;
}
function getClipboard() {
	return getMainWindow().clipboard;
}
