/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ./nsIPermissionManager.idl
 */

#ifndef __gen_nsIPermissionManager_h__
#define __gen_nsIPermissionManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsISimpleEnumerator_h__
#include "nsISimpleEnumerator.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

class nsIObserver; /* forward declaration */


/* starting interface:    nsIPermissionManager */
#define NS_IPERMISSIONMANAGER_IID_STR "4f6b5e00-0c36-11d5-a535-0010a401eb10"

#define NS_IPERMISSIONMANAGER_IID \
  {0x4f6b5e00, 0x0c36, 0x11d5, \
    { 0xa5, 0x35, 0x00, 0x10, 0xa4, 0x01, 0xeb, 0x10 }}

class NS_NO_VTABLE nsIPermissionManager : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IPERMISSIONMANAGER_IID)

  /**
   * Allowed return values from the testPermission method
   */
  enum { UNKNOWN_ACTION = 0U };

  enum { ALLOW_ACTION = 1U };

  enum { DENY_ACTION = 2U };

  /**
   * These values are the different types of permissions supported
   */
  enum { COOKIE_TYPE = 0U };

  enum { IMAGE_TYPE = 1U };

  enum { POPUP_TYPE = 2U };

  /**
   * Add permission information for a given URI and permission type.
   * @param uri is the website to add the permission for
   * @param permission is one of the enumerated permission actions above
   * @param type is one of the enumerated permission types above
   */
  /* void add (in nsIURI uri, in PRUint32 type, in PRUint32 permission); */
  NS_IMETHOD Add(nsIURI *uri, PRUint32 type, PRUint32 permission) = 0;

  /**
   * Remove permission information for a given URI and permission type.
   * Note that this method takes a host string, not an nsIURI.
   * @param host is the host to remove the permission for
   * @param type is one of the enumerated permission types above
   */
  /* void remove (in AUTF8String host, in PRUint32 type); */
  NS_IMETHOD Remove(const nsACString & host, PRUint32 type) = 0;

  /**
   * Clear permission information for all websites.
   */
  /* void removeAll (); */
  NS_IMETHOD RemoveAll(void) = 0;

  /**
   * Test whether a website has permission to perform the given action.
   * @param  uri   the website to be tested
   * @param  type  one of the enumerated types above
   * @return       one of the enumerated permission actions above
   */
  /* PRUint32 testPermission (in nsIURI uri, in PRUint32 type); */
  NS_IMETHOD TestPermission(nsIURI *uri, PRUint32 type, PRUint32 *_retval) = 0;

  /**
   * Allows enumeration of all stored permissions
   * @return an nsISimpleEnumerator interface that allows access to
   *         nsIPermission objects
   */
  /* readonly attribute nsISimpleEnumerator enumerator; */
  NS_IMETHOD GetEnumerator(nsISimpleEnumerator * *aEnumerator) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIPERMISSIONMANAGER \
  NS_IMETHOD Add(nsIURI *uri, PRUint32 type, PRUint32 permission); \
  NS_IMETHOD Remove(const nsACString & host, PRUint32 type); \
  NS_IMETHOD RemoveAll(void); \
  NS_IMETHOD TestPermission(nsIURI *uri, PRUint32 type, PRUint32 *_retval); \
  NS_IMETHOD GetEnumerator(nsISimpleEnumerator * *aEnumerator); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIPERMISSIONMANAGER(_to) \
  NS_IMETHOD Add(nsIURI *uri, PRUint32 type, PRUint32 permission) { return _to Add(uri, type, permission); } \
  NS_IMETHOD Remove(const nsACString & host, PRUint32 type) { return _to Remove(host, type); } \
  NS_IMETHOD RemoveAll(void) { return _to RemoveAll(); } \
  NS_IMETHOD TestPermission(nsIURI *uri, PRUint32 type, PRUint32 *_retval) { return _to TestPermission(uri, type, _retval); } \
  NS_IMETHOD GetEnumerator(nsISimpleEnumerator * *aEnumerator) { return _to GetEnumerator(aEnumerator); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIPERMISSIONMANAGER(_to) \
  NS_IMETHOD Add(nsIURI *uri, PRUint32 type, PRUint32 permission) { return !_to ? NS_ERROR_NULL_POINTER : _to->Add(uri, type, permission); } \
  NS_IMETHOD Remove(const nsACString & host, PRUint32 type) { return !_to ? NS_ERROR_NULL_POINTER : _to->Remove(host, type); } \
  NS_IMETHOD RemoveAll(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveAll(); } \
  NS_IMETHOD TestPermission(nsIURI *uri, PRUint32 type, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->TestPermission(uri, type, _retval); } \
  NS_IMETHOD GetEnumerator(nsISimpleEnumerator * *aEnumerator) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEnumerator(aEnumerator); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsPermissionManager : public nsIPermissionManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIPERMISSIONMANAGER

  nsPermissionManager();
  virtual ~nsPermissionManager();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsPermissionManager, nsIPermissionManager)

nsPermissionManager::nsPermissionManager()
{
  /* member initializers and constructor code */
}

nsPermissionManager::~nsPermissionManager()
{
  /* destructor code */
}

/* void add (in nsIURI uri, in PRUint32 type, in PRUint32 permission); */
NS_IMETHODIMP nsPermissionManager::Add(nsIURI *uri, PRUint32 type, PRUint32 permission)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void remove (in AUTF8String host, in PRUint32 type); */
NS_IMETHODIMP nsPermissionManager::Remove(const nsACString & host, PRUint32 type)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeAll (); */
NS_IMETHODIMP nsPermissionManager::RemoveAll()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRUint32 testPermission (in nsIURI uri, in PRUint32 type); */
NS_IMETHODIMP nsPermissionManager::TestPermission(nsIURI *uri, PRUint32 type, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator enumerator; */
NS_IMETHODIMP nsPermissionManager::GetEnumerator(nsISimpleEnumerator * *aEnumerator)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_PERMISSIONMANAGER_CONTRACTID "@mozilla.org/permissionmanager;1"
#define PERM_CHANGE_NOTIFICATION "perm-changed"

#endif /* __gen_nsIPermissionManager_h__ */
