

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom.html;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;

//XPCOM import
import org.mozilla.xpcom.*;


public class HTMLAnchorElementImpl extends HTMLElementImpl implements org.w3c.dom.html.HTMLAnchorElement
{
    protected HTMLAnchorElementImpl(nsIDOMHTMLAnchorElement mozInst)
    {
        super( mozInst );
    }

    public static HTMLAnchorElementImpl getDOMInstance(nsIDOMHTMLAnchorElement mozInst)
    {
        HTMLAnchorElementImpl node = (HTMLAnchorElementImpl) instances.get(mozInst);
        return node == null ? new HTMLAnchorElementImpl(mozInst) : node;
    }
    
    public nsIDOMHTMLAnchorElement getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMHTMLAnchorElement) moz;
    }
    
    public void setCharset(String charset)
    {
        getInstance().setCharset(charset);
    }
    
    public String getCoords()
    {
        String result = getInstance().getCoords();
        return result;
    }
    
    public String getHreflang()
    {
        String result = getInstance().getHreflang();
        return result;
    }
    
    public void setRev(String rev)
    {
        getInstance().setRev(rev);
    }
    
    public String getRev()
    {
        String result = getInstance().getRev();
        return result;
    }
    
    public String getTarget()
    {
        String result = getInstance().getTarget();
        return result;
    }
    
    public void setRel(String rel)
    {
        getInstance().setRel(rel);
    }
    
    public String getRel()
    {
        String result = getInstance().getRel();
        return result;
    }
    
    public void setType(String type)
    {
        getInstance().setType(type);
    }
    
    public String getCharset()
    {
        String result = getInstance().getCharset();
        return result;
    }
    
    public String getName()
    {
        String result = getInstance().getName();
        return result;
    }
    
    public void blur()
    {
        getInstance().blur();
    }
    
    public void setTabIndex(int tabIndex)
    {
        getInstance().setTabIndex(tabIndex);
    }
    
    public String getAccessKey()
    {
        String result = getInstance().getAccessKey();
        return result;
    }
    
    public void setName(String name)
    {
        getInstance().setName(name);
    }
    
    public void setTarget(String target)
    {
        getInstance().setTarget(target);
    }
    
    public String getType()
    {
        String result = getInstance().getType();
        return result;
    }
    
    public void focus()
    {
        getInstance().focus();
    }
    
    public void setAccessKey(String accessKey)
    {
        getInstance().setAccessKey(accessKey);
    }
    
    public void setCoords(String coords)
    {
        getInstance().setCoords(coords);
    }
    
    public int getTabIndex()
    {
        int result = getInstance().getTabIndex();
        return result;
    }
    
    public void setHreflang(String hreflang)
    {
        getInstance().setHreflang(hreflang);
    }
    
    public void setHref(String href)
    {
        getInstance().setHref(href);
    }
    
    public String getShape()
    {
        String result = getInstance().getShape();
        return result;
    }
    
    public String getHref()
    {
        String result = getInstance().getHref();
        return result;
    }
    
    public void setShape(String shape)
    {
        getInstance().setShape(shape);
    }
    
}
