/*
     kalc: A Scientific RPN Calculator
     Copyright (C) 1999-2000 Eduardo M Kalinowski (ekalin@iname.com)

     This program is free software. You may redistribute it, but only in
     its whole, unmodified form. You are allowed to make changes to this
     program, but you must not redistribute the changed version.

     This program is distributed in the hope it will be useful, but there
     is no warranty.

     For details, see the COPYING file.
*/

#ifndef __REALFUNCTIONS_H
#define __REALFUNCTIONS_H 1

/************************
 * Arithmetic functions *
 ************************/
#define re_inv(n)      (1 / (n))
#define re_chs(n)      (-(n))
#define re_abs(n)      (((n) > 0) ? (n) : -(n))
#define re_ceil(n)     (ceil(n))
#define re_floor(n)    (floor(n))
#define re_pctOf(n, p) ((n) * (p) / 100)
#define re_pctT(n, p)  (100 * (p) / (n))
#define re_pctCh(n, p) (100 * ((p) - (n)) / (n))
#define re_mod(n, p)   (n - p*floor(n/p))
#define re_lcm(u, v)   ((u)*(v)/re_gcd(u, v))


/*************************
 * Exponential functions *
 *************************/
#define re_exp(n)    (exp(n))
#define re_ln(n)     (log(n))
#define re_pow(n, p) (pow(n, p))
#define re_expm1(n)  (expm1(n))
#define re_lnp1(n)   (log1p(n))
#define re_log(n)    (log10(n))
#define re_alog(n)   (pow(10, n))
#define re_sqrt(n)   (sqrt(n))

/***************************
 * Trigonometric functions *
 ***************************/
#define re_sin(n)      (sin(n))
#define re_cos(n)      (cos(n))
#define re_tan(n)      (tan(n))
#define re_sec(n)      (1/cos(n))
#define re_csc(n)      (1/sin(n))
#define re_cot(n)      (cos(n)/sin(n))
#define re_asin(n)     (asin(n))
#define re_acos(n)     (acos(n))
#define re_atan(n)     (atan(n))
#define re_atan2(n, p) (atan2(n, p))
#define re_asec(n)     (acos(1/(n)))
#define re_acsc(n)     (asin(1/(n)))
#define re_acot(n)     (atan(1/(n)))
#define re_vers(n)     (1-cos(n))
#define re_hav(n)      (re_vers(n)/2)
#define re_dTOr(n)     ((n) * PI/180)
#define re_rTOd(n)     ((n) * 180/PI)


/************************
 * Hyperbolic functions *
 ************************/
#define re_sinh(n)  (sinh(n))
#define re_cosh(n)  (cosh(n))
#define re_tanh(n)  (tanh(n))
#define re_asinh(n) (asinh(n))
#define re_acosh(n) (acosh(n))
#define re_atanh(n) (atanh(n))
#define re_sech(n)  (1/cosh(n))
#define re_csch(n)  (1/sinh(n))
#define re_coth(n)  (cosh(n)/sinh(n))
#define re_asech(n) (acosh(1/(n)))
#define re_acsch(n) (asinh(1/(n)))
#define re_acoth(n) (atanh(1/(n)))
#define re_gd(n)    (2*atan(exp(n)) - PI/2)
/* #define re_invgd(n) (ln(re_sec(z) + tan(z)) */


/***************************
 * Miscellaneous functions *
 ***************************/
#define re_ip(n)      (re_ipORfp(n, 1))
#define re_fp(n)      (re_ipORfp(n, 0))
#define re_gammap1(n) (exp(lgamma((n) + 1)) * signgam)
#define re_lgamma(n)  (lgamma(n))
#define re_perm(n, p) (re_gammap1(n) / re_gammap1((n) - (p)))
#define re_comb(n, p) (re_gammap1(n) / (re_gammap1(p) * re_gammap1((n) - (p))))
#define re_mant(n)    ((n == 0) ? 0 : (n) / re_alog(re_xpon(n)))
#define re_min(n, p)  (((n) < (p)) ? (n) : (p))
#define re_max(n, p)  (((n) > (p)) ? (n) : (p))
#define re_sign(n)    (((n) < 0) ? -1 : ((n) != 0))
#define re_psign(n)   (((n) < 0) ? -1 : 1)
#define re_rnd(n, d)  (floor((n)*pow(10.,(d))+.5)/pow(10.,(d)))

double re_gcd(double u, double v);
double re_xroot(double n, double e);
double re_xpon(double n);
double re_ipORfp(double n, int integer);

#endif /* __REALFUNCTIONS_H */
