#include <config.h>

/* If we don't use history databases, then these routines will */
/* get compiled and used.  If we do, the routines in chkhistory_db.c will */
/* be used. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "suck_config.h"
#include "suck.h"
#include "both.h"
#include "chkhistory.h"
#include "suckutils.h"
#include "phrases.h"
#include "timer.h"
#include "ssort.h"

/* this is almost a duplicate of dedupe_list() */
/* put items in array, qsort it, then work thru history file, and use bsearch to match em */
void chkhistory(PMaster master) {
	FILE *fhist;
	PList *array, ptr, curr, prev, tptr;
	int i=0, nrfound=0;
	char *cptr, linein[MAXLINLEN+1];
	
	if((fhist = fopen(master->history_file, "r")) == NULL) {
		MyPerror(master->history_file);
	}
	else {	
		if(master->debug == TRUE) {
			do_debug("Chking %d items - master->nritems\nReading history file - %s\n", master->nritems, master->history_file);
		}
		print_phrases(master->msgs, chkh_phrases[1], NULL);
		fflush(master->msgs);	/* so msg gets printed */

		TimerFunc(TIMER_START, 0L, NULL);

		/* 1. throw em into the array */
		if((array = calloc(master->nritems, sizeof(PList))) == NULL) {
			error_log(ERRLOG_REPORT, chkh_phrases[4], NULL);
		}
		else {
			ptr = master->head;
			i = 0;
			while(ptr != NULL) {
				array[i] = ptr;
				i++;
				ptr = ptr->next;
			}
		
			/* step 2, sort em */
			ssort(array, master->nritems, 1); /* start with depth of 1 cause all start with < */

			/* step 3, find and mark dupes */
			/* history file can have two valid types of lines */
			/* the ones we are interested in is the ones that start with < */
			/* we ignore the ones that start with [  and report the rest */
			while(fgets(linein, MAXLINLEN, fhist) != NULL) {
				if(linein[0] == '<') {
					/* make sure we have valid msgid and null terminate it */
					if((cptr = strchr(linein, '>'))  == NULL) {
						error_log(ERRLOG_REPORT, chkh_phrases[2], linein, NULL);
					}
					else {
						*(cptr+1) = '\0';
						if((tptr = my_bsearch(array, linein, master->nritems)) != NULL) {
							/* found in our array flag for deletion */
							/* it returns a PList * */
							tptr->delete = TRUE;
							nrfound++;
						}
					}
				}
			}
			if(master->debug == TRUE) {
				do_debug("%d duplicates found\n", nrfound);
			}
			/* step 4, delete em */
			curr = master->head;
			prev = NULL;
			while(curr != NULL) {			
				if( curr->delete == TRUE) {
				/* nuke it */
					master->nritems--;
					if(prev == NULL) {
						/* remove master node */
						master->head = curr->next;
						free_one_node(curr);
						curr = master->head;
					}
					else {
						prev->next = curr->next;
						free_one_node(curr);
						curr = prev->next;
					}
				}
				else {
					prev = curr;
					curr = curr->next;
				}				
			}
		
			/* all done free up mem */
			free(array);
		}
		fclose(fhist);
		TimerFunc(TIMER_TIMEONLY, 0l, master->msgs);
		print_phrases(master->msgs, chkh_phrases[3], str_int(nrfound), NULL);
	}	
}

