#ifndef _H_JInterpolate
#define _H_JInterpolate

/******************************************************************************
 JInterpolate.h

	Interface for the JInterpolate class.

	Copyright  1998 by Dustin Laurence.  All rights reserved.

	Base code generated by Codemill v0.1.0

 *****************************************************************************/

// Superclass Header
#include <JSubstitute.h>


class JInterpolate : public JSubstitute
{
public:

	JInterpolate();
	JInterpolate(const JCharacter* source, const JArray<JIndexRange>* matchList);
	virtual ~JInterpolate();

	void SetMatchResults(const JCharacter* source, const JArray<JIndexRange>* matchList);

protected:

	virtual JBoolean GetValue(const JString& name, JString* value) const;

private:

	const JCharacter*          itsSource;
	const JArray<JIndexRange>* itsMatchList;

private:

	// not allowed

	JInterpolate(const JInterpolate& source);
	const JInterpolate& operator=(const JInterpolate& source);
};

/******************************************************************************
 SetMatchResults

 *****************************************************************************/

inline void
JInterpolate::SetMatchResults
	(
	const JCharacter*          source,
	const JArray<JIndexRange>* matchList
	)
{
	itsSource    = source;
	itsMatchList = matchList;
}

#endif
