/******************************************************************************
 JTEStyler.h

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JTEStyler
#define _H_JTEStyler

#include <JTextEditor.h>	// need definition of Font

class JTEStyler
{
public:

	JTEStyler();

	virtual ~JTEStyler();

	static JArray<JIndex>*	NewTokenStartList();

	void	UpdateStyles(const JTextEditor* te,
						 const JString& text, JRunArray<JTextEditor::Font>* styles,
						 JIndexRange* recalcRange, JIndexRange* redrawRange,
						 const JBoolean deletion, JArray<JIndex>* tokenStartList);

	JBoolean	IsActive() const;
	void		SetActive(const JBoolean active);

protected:

	virtual void	Scan(istream& input) = 0;
	virtual void	PreexpandCheckRange(const JString& text,
										const JRunArray<JTextEditor::Font>& styles,
										const JIndexRange& modifiedRange,
										const JBoolean deletion,
										JIndexRange* checkRange);
	void			ExtendCheckRange(const JIndex newEndIndex);

	const JTextEditor*					GetTextEditor() const;
	const JFontManager*					GetFontManager() const;
	const JFontStyle&					GetDefaultFontStyle() const;
	const JString&						GetText() const;
	const JRunArray<JTextEditor::Font>&	GetStyles() const;

	JBoolean	SetFont(const JIndexRange& range, const JFontStyle& style);
	void		SaveTokenStart();

private:

	JBoolean	itsActiveFlag;

	const JTextEditor*				itsTE;			// not owned; NULL unless lexing
	const JFontManager*				itsFontMgr;		// not owned; NULL unless lexing
	const JString*					itsText;		// not owned; NULL unless lexing
	JRunArray<JTextEditor::Font>*	itsStyles;		// not owned; NULL unless lexing

	JBoolean	itsRedoAllFlag;						// kTrue => itsStyles is *not* full
	JString		itsFontName;
	JSize		itsFontSize;
	JFontStyle	itsDefFontStyle;
	JFontID		itsDefFontID;

	JIndexRange*	itsRecalcRange;					// not owned; NULL unless lexing
	JIndexRange*	itsRedrawRange;					// not owned; NULL unless lexing
	JIndexRange		itsCheckRange;

	JArray<JIndex>*	itsTokenStartList;				// not owned; NULL unless lexing
	JSize			itsTokenStartFactor;
	JSize			itsTokenStartCount;

	// information about next token that will be received

	JIndex	itsTokenStart;
	JIndex	itsTokenRunIndex;						// invalid when itsRedoAllFlag
	JIndex	itsTokenFirstInRun;						// invalid when itsRedoAllFlag

private:

	JBoolean	OnlyColorChanged(JFontStyle s1, JFontStyle s2) const;

	// not allowed

	JTEStyler(const JTEStyler& source);
	const JTEStyler& operator=(const JTEStyler& source);
};


/******************************************************************************
 Active

 ******************************************************************************/

inline JBoolean
JTEStyler::IsActive()
	const
{
	return itsActiveFlag;
}

inline void
JTEStyler::SetActive
	(
	const JBoolean active
	)
{
	itsActiveFlag = active;
}

/******************************************************************************
 GetTextEditor (protected)

 ******************************************************************************/

inline const JTextEditor*
JTEStyler::GetTextEditor()
	const
{
	return itsTE;
}

/******************************************************************************
 GetFontManager (protected)

 ******************************************************************************/

inline const JFontManager*
JTEStyler::GetFontManager()
	const
{
	return itsFontMgr;
}

/******************************************************************************
 GetDefaultFontStyle (protected)

 ******************************************************************************/

inline const JFontStyle&
JTEStyler::GetDefaultFontStyle()
	const
{
	return itsDefFontStyle;
}

/******************************************************************************
 GetText (protected)

 ******************************************************************************/

inline const JString&
JTEStyler::GetText()
	const
{
	return *itsText;
}

/******************************************************************************
 GetStyles (protected)

 ******************************************************************************/

inline const JRunArray<JTextEditor::Font>&
JTEStyler::GetStyles()
	const
{
	return *itsStyles;
}

/******************************************************************************
 OnlyColorChanged (private)

	We don't use JFontStyle& because we modify the values.

 ******************************************************************************/

inline JBoolean
JTEStyler::OnlyColorChanged
	(
	JFontStyle s1,
	JFontStyle s2
	)
	const
{
	s1.color = s2.color = 0;	// make sure the color is the same
	return JI2B(s1 == s2);		// avoids maintenance when fields are added
}

#endif
