/******************************************************************************
 jMath.h

	Header for jMath.cc

	Copyright  1992-99 John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_jMath
#define _H_jMath

#include <math.h>
#include <jNumericConstants.h>		// for convenience

long JRound(const double);
int  JSign(const double);

double	JASinh(const double);
double	JACosh(const double);
double	JATanh(const double);

inline long
JLFloor
	(
	const double x
	)
{
	return JRound( floor(x) );
}

inline long
JLCeil
	(
	const double x
	)
{
	return JRound( ceil(x) );
}

inline long
JLAbs
	(
	const long x
	)
{
	return (x >= 0 ? x : -x);
}

inline long
JTruncate
	(
	const double x
	)
{
	return (x >= 0.0 ? JLFloor(x) : JLCeil(x));
}

#endif
