/******************************************************************************
 testnew.cc

	Test program for the JCore memory manager system.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

#include <iostream.h>
#include <iomanip.h>

// To make JCore shut up
#include <JUserNotification.h>
#include <JCreateProgressDisplay.h>

	JUserNotification* gUserNotification = NULL;
	JCreateProgressDisplay* gCreatePG = NULL;
	const JCharacter* kJMonospaceFontName = NULL;
	const JCharacter* kJDefaultFontName = NULL;


#include <JMemoryManager.h>
#include <JMMErrorPrinter.h>

#include <JArray.h>

#include <jAssert.h>

/******************************************************************************
 main

 *****************************************************************************/

int
main()
{
	cout << "   Testing object new/delete, should never fail" << endl;
	long* aLong = new long;
	delete aLong;

	cout << "\n   Testing array new/delete, should never fail" << endl;
	aLong = new long[15];
	delete[] aLong;

	cout << "\n   Testing initialization value" << endl;
	const JSize blockSize = 4;
	aLong = new long[blockSize];
	cout << setbase(16) << "\n   Block of longs initialized to: ";
	for (JIndex i=0;i<blockSize;i++)
		{
		cout << aLong[i];
		}
	cout << setbase(10) << endl;
	delete[] aLong;
	cout << "\n   Testing shredding value (slightly dangerous!)" << endl;
	cout << setbase(16) << "\n   Block of longs shredded to: ";
	for (JIndex i=0;i<blockSize;i++)
		{
		cout << aLong[i];
		}
	cout << setbase(10) << endl;

//	JMemoryManager::Instance()->DiscardDeletionRecords();

	cout << "\n   Deleting unallocated memory, will fail if allocations are being"
	     << "\n   recorded, will succeed with system-dependent results (dumps core"
	     << "\n   on Linux) if allocations are not being recorded" << endl;
	double* aDouble = (double*) 0x34343;
	delete aDouble;
	delete[] aDouble;

//	JMemoryManager::Instance()->CancelRecordAllocated();

	cout << "\n   Multiple deleting object.  Should fail as 'delete unallocated'"
	     << "\n   but *not* dump core if allocations are being recorded, or should fail"
	     << "\n   as double deletion if deallocations are being recorded.  Otherwise,"
	     << "\n   will succeed with system-dependent results" << endl;
	float* aFloat = new float;



	delete aFloat;



	delete aFloat;

	delete[] aFloat;

	cout << "\n   Multiple deleting array.  Should fail as 'delete unallocated'"
	     << "\n   but *not* dump core if allocations are being recorded, or should fail"
	     << "\n   as double deletion if deallocations are being recorded.  Otherwise,"
	     << "\n   will succeed with system-dependent results" << endl;
	aFloat = new float[5];



	delete[] aFloat;



	delete[] aFloat;

	delete aFloat;

	cout << "\n   Array deleting object allocation, should fail if"
	     << "\n   allocations are being recorded" << endl;
	int* aInt = new int;
	delete[] aInt;

	cout << "\n   Object deleting array allocation, should fail if"
	     << "\n   allocations are being recorded" << endl;
	aDouble = new double[10];
	delete aDouble;

	cout << "\nDeleting NULL as object, should not fail unless it has been disallowed" << endl;
	aFloat = NULL;
	delete aFloat;
	cout << "\nNow deleting as array, ***WHY DOES THIS FAIL?!?***" << endl;
	delete[] aFloat;

	JMemoryManager::Instance()->PrintMemoryStats();

	cout << "\nAllocating two more memory blocks, should count properly" << endl;
	char* aChar = new char[30];
	aChar = new char[30];

	JMemoryManager::Instance()->PrintMemoryStats();

	cout << "\nAllocating JArray--how many blocks does it need?" << endl;

	JArray<int>* array = new JArray<int>;

	JMemoryManager::Instance()->PrintMemoryStats();

	cout << "\nTwo user blocks plus a JArray are undeleted--should show up on final stats" << endl;

	return 0;
}
