/* $Id: ToggleBG.C,v 1.1.1.1 2001/04/09 13:34:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ToggleBG.h>
/* ToggleButtonGadgetClass Members */

/* constructors */
ToggleButtonGadget::ToggleButtonGadget(Widget w_parent, char *str, KeySym mn,
                                       _XtString acc, char *accText, _XtString name) 
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   labelString(str);
   manage();

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(accText) acceleratorText(accText);
}

ToggleButtonGadget::ToggleButtonGadget(Widget w_parent, 
                                       ArgList arglist, 
                                       Cardinal cnt,
                                       _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
   manage();
}

ToggleButtonGadget::ToggleButtonGadget(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

ToggleButtonGadget::ToggleButtonGadget(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}
