//
// dlgwin.C  last changed Nov. 11, 1994
// A widget demo.
// This application should run under Motif, Xaw and TIP
//
// (NOTE: When using TIP over stdio you have to redirect
//  stderr into a file!)
//

#include <stream.h>
#include <stdlib.h>
#include <xmObject.h>

class DemoDialog : public XmDialogWindow
{
	bool initWindowSize(int&, int&, int&, int&);
	void initialize()	{ createContents(); initContents(); }

	void createContents();
	void initContents();

	void createMenu();

	void myRadioButton(XmRadioButton*);
	void myCheckBox(XmCheckBox*);
	void myEdit(XmEdit*);
	void myListBox(XmListBox*);
	void myComboBox(void*);
	void myPushButton(XmPushButton*);
	void myQuitButton(XmPushButton*);
public:
	DemoDialog(char* name = "Demo Dialog", XmObject* parent = NULL) : XmDialogWindow(name)
	{ createMenu(); }
#ifdef __GNUG__ // bug in gcc < 2.6
	bool add(XmControl* c, XmObject* o = NULL, cbProc p = NULL, void* d = CB_OBJ_PTR)	{ return(XmDialogWindow::add(c, o, p, d)); }
	bool add(XmComboBox* c, XmObject* o = NULL, cbProc p = NULL, void* cd = CB_OBJ_PTR)	{ return(add((XmControl* )((void* )c), o, p, cd)); }
#endif
};


// implementation ///////////////////////////////////////////////////////

void DemoDialog::createMenu()
{
	XmDropdownMenu* m = createDropdownMenu();

	m->addLabels("&File", NULL);

	m->setCurrentLabel("File");
	m->addItems(Entry("E&xit", CBK(DemoDialog, myQuitButton)), NULLENTRY);
}

#include "demodlg.C"

char* items[] = { "One", "Two", "Three", "Four", "Five", "Six", NULL };

void DemoDialog::initContents()
{
	setBackgroundColor("green");
	setForegroundColor("yellow");
	groupBox("GroupBox")->setBackgroundColor("red");
	groupBox("GroupBox")->setForegroundColor("blue");

	radioButton("RadioButton1")->setCallback(this, CBK(DemoDialog, myRadioButton));
	radioButton("RadioButton2")->setCallback(this, CBK(DemoDialog, myRadioButton));
	radioButton("RadioButton3")->setCallback(this, CBK(DemoDialog, myRadioButton));
	pushButton("PushButton")->setCallback(this, CBK(DemoDialog, myPushButton));
	checkBox("CheckBox")->setCallback(this, CBK(DemoDialog, myCheckBox));
	edit("Edit1")->setCallback(this, CBK(DemoDialog, myEdit));
	edit("Edit2")->setCallback(this, CBK(DemoDialog, myEdit));
	listBox("ListBox")->addAll(items);
	listBox("ListBox")->setBackgroundColor("cyan");
	listBox("ListBox")->setForegroundColor("pink");
	listBox("ListBox")->setCallback(this, CBK(DemoDialog, myListBox));
	comboBox("ComboBox")->addAll(items);

	((XmGroupBox*)comboBox("ComboBox"))->setBackgroundColor("orange");
	((XmGroupBox*)comboBox("ComboBox"))->setForegroundColor("brown");
	((XmGroupBox* )comboBox("ComboBox"))->setCallback(this, CBK(DemoDialog, myComboBox));
	pushButton("QuitButton")->setCallback(this, CBK(DemoDialog, myQuitButton));
}

void DemoDialog::myPushButton(XmPushButton* p)
{
	cerr << "pushButton: " << p->getName() << "\n";
}

void DemoDialog::myCheckBox(XmCheckBox* b)
{
	cerr << "checkBox: " << b->getName() << " state: " << b->getState() << "\n";
}

void DemoDialog::myRadioButton(XmRadioButton* r)
{
	cerr << "radioButton: " << r->getName() << " selected.\n";
}

void DemoDialog::myEdit(XmEdit* e)
{
	cerr << "edit: " << e->getName() << " new text: " << e->getText() << "\n";
}

void DemoDialog::myListBox(XmListBox* l)
{
	cerr << "listBox: " << l->getName() << " selection: " << l->selectedItem() << " (" << l->selectedIndex() << ")\n";
	cerr << "  currently selected: \n";
	char** strings = l->selectedItems();
	int* ndxs = l->selectedIndices();
	for(int i = 0; strings[i]; i++)
		cerr << strings[i] << " (" << ndxs[i] << ")\n";
	cerr << "\n";
}

void DemoDialog::myComboBox(void*)
{
	XmComboBox* cbx = comboBox("ComboBox");
	cerr << "comboBox: " << cbx->getName() << "\n";
	cerr << "current text: " << cbx->getText() << ".\n";
}

void DemoDialog::myQuitButton(XmPushButton*)
{
	delete this;
}


// application init method ///////////////////////////////////////////

void XmApp::initialize()
{
	(new DemoDialog)->open();
};


