
/* 	Xtk constants and typedefs needed to use Xm++ without including
	the X11 includes...
*/
	
#include <string.h>
#include <strstream.h>
#include <stdlib.h>

#define XtNcallback	 	"callback"

typedef unsigned long XID;

typedef XID Window;
typedef XID Drawable;
typedef XID Font;
typedef XID Pixmap;
typedef XID Cursor;
typedef XID Colormap;
typedef XID GContext;
typedef XID KeySym;

class XmTclController;

typedef XmTclController* Widget;
typedef void *XtAppContext;
typedef void *XrmDatabase;
typedef void *GC;

typedef int Display;
typedef int Screen;

typedef char Boolean;
typedef long XtArgVal;
typedef long XrmValue;
typedef void* XtPointer;
typedef unsigned short Dimension;
typedef short Position;

typedef char* String;
typedef char* XString;
typedef char* XmString;

typedef struct {
	char dum[200];
} XGCValues;

typedef struct {
    XString      name;
    XtArgVal    value;
} Arg, *ArgList;

extern void xmTclInitApp();
extern void xmTclQuitApp();
extern void xmTclNextEvent();
extern void xmTclMainLoop();

extern int tclOutput(char*);
extern int tclInput(char*, char = '\b');

template<class T> class mincoll;

#ifndef BOOL_DEFINED
typedef enum bool { TRUE = 1, FALSE = 0 };
#define BOOL_DEFINED
#endif

class XmObject;

#define _mkstr(x) (strcpy(new char[strlen(x) + 1], x))
#define _cmpstr(x, y) (strcmp(x, y) ? 0 : 1)

#define cbName2Reason(x) (strcmp(x, "callback") ? 0 : 0) // 1)

struct XmTclCallback
{
	int reason;
	char* name;
	void* client_data;
	
	XmTclCallback(int r, void* d, char* n = NULL)	{ reason = r; client_data = d; name = n ? _mkstr(n) : n; }
	XmTclCallback(char* r, void* d, char* n = NULL)	{ reason = cbName2Reason(r); client_data = d; name = n ? _mkstr(n) : n; }
	~XmTclCallback()				{ delete name; }

	int matches(int r, char* n = "")		{ return(reason == r && (name ? _cmpstr(name, n) : 1)); }

	int equ(int r, void* d, char* n = "")		{ return(reason == r && d == client_data && (name ? _cmpstr(name, n) : 1)); }
	int equ(char* r, void* d, char* n = "")		{ return(reason == cbName2Reason(r) && d == client_data && (name ? _cmpstr(name, n) : 1)); }
};

extern bool tclRootApp;

#define XM_TCL_MAGIC_CONST 69696969

class XmTclController
{
	long magic;
	char* name;		// used only in child widgets...
	char* varName;
	ostrstream* curCmd;
	bool tclOk;
	bool tclRealized;
	bool tclConstrained;
	bool tclAutoRealize;
	bool tclToplevel;
	bool tclRoot;
	XmObject* obj;
	mincoll<XmTclCallback*>* callbacks;
	mincoll<char*>* names;
	int nameCount;
	XmTclController* parent;
	XmTclController* master;
	mincoll<XmTclController*>* children;
	int childrenCount;
	char* packingOptions;
	long answerSerial;
	char* answerValue;
friend class XmDialogPane;
friend class XmListBox;
friend class XmEdit;
friend class XmComboBox;
	void setParent(XmTclController* p)	{ if(parent) parent->removeChild(this); parent = NULL; if(p) { parent = p; p->addChild(this); } }
	void setMaster(XmTclController* m)	{ master = m; }
friend class XmApp;
	void setRoot()		{ tclRoot = TRUE; }
friend class XmDialog;
friend class XmUserDialog;
	void setToplevel()	{ tclToplevel = TRUE; }
friend void xmTclNextEvent();
	void setAnswer(long sn, char* answer)	{ delete answerValue; answerSerial = sn; answerValue = _mkstr(answer); }
public:
	XmTclController(XmObject*, char*, XmTclController*);
	~XmTclController();

	bool isValid()		{ return(magic == XM_TCL_MAGIC_CONST ? TRUE : FALSE); }

	ostrstream& cmd()	{ return(*(curCmd ? curCmd : (tclOk = TRUE, curCmd = new ostrstream))); }
	char* getCmd()		{ if(curCmd) curCmd->put('\0'); return(curCmd ? curCmd->str() : ""); }
	void resetCmd()		{ delete curCmd; curCmd = NULL; }
	void execCmd()		{ tclOutput(getCmd()); resetCmd(); execChildrenCmds(); }
	void execIfVisible()	{ if(tclRealized) execCmd(); }
	void performCmd(char* c)	{ tclOutput(c); }
	
	void dontRealize()	{ tclAutoRealize = TRUE; }
	void realize();

	bool addCbk(char* n, void* d, char* = NULL);
	bool removeCbk(char* n, void* d, char* = NULL);
	void callCallbacks(int, char*, char*);	// call every cb in the list...

	char* getValue(char*, int = 100);	// make value request
	char* getVarValue(int = 100);		// make variable value request
	
	int addName(char*);
	int insertName(char*, int);
	int removeName(char*);
	int nameIndex(char*);
	char* namePath(char*);
	
	char* getName()		{ return(name); }
	char* getVarName()	{ return(varName); }

	char* getPath(bool = FALSE);
	void setName(char*);
	
	XmTclController* getParent()	{ return(parent); }
	XmTclController* getMaster()	{ return(master); }
	char* getText()			{ return("NotImplemented"); }
	void addChild(XmTclController*);
	void removeChild(XmTclController*);
	XmTclController* getChild(char*);	// childName or one of names matches!
	void execChildrenCmds();

	char* processArgs(ArgList, int);	// builds tcl statement...
	char* resizeCmd(int, int);		// class dependend...

	bool isOk()			{ return(tclOk); } // TRUE if Tcl - created...
	bool isVisible()		{ return(tclRealized || tclToplevel ? TRUE : FALSE); }
	bool isReframeable()		{ return(!tclConstrained ? TRUE : FALSE); }
	XmObject* getXmObj()		{ return(obj); }
	
	void setConstrained(bool b)	{ tclConstrained = b; }
	void setPackingOptions(char* s)	{ packingOptions = _mkstr(s); }
	
	char* callbackString(char* = NULL, char* = NULL, int = 0);
	
	char* getConfigValue(char*)	{ return(""); }
};

#define widpath (wid->getPath())
#define widcmd (wid->cmd())

#define mkargval(x) _mkstr(x)

#define ANY_CALLBACK	"any"

#define getObjName(x)      (x->getName())
#define getObjText(x)      (x->getText())
#define getObjParent(x)    (x->getParent())
#define getObjChild(x, n)  (x->getChild(n))
#define isObjVisible(x)    (x->isVisible())

#define XtParent(x) getObjParent(x)


extern int x2tclX(XmObject*, int);
extern int x2tclY(XmObject*, int);
extern int tcl2xX(XmObject*, int);
extern int tcl2xY(XmObject*, int);

