//
// Qt Example Widget: DigitalClock (dclock.h)
//
// Definition of DigitalClock widget.
//
// The DigitalClock widget is a stand-alone widget that you may
// freely use in your Qt application (at your own risk!)
// See the widgets/widgets.cpp demo application for how to add
// a DigitalClock to your application.
//

#ifndef DCLOCK_H
#define DCLOCK_H

#include <qlcdnum.h>


class DigitalClock : public QLCDNumber		// digital clock widget
{
    Q_OBJECT
public:
    DigitalClock( QWidget *parent=0, const char *name=0 );

protected:					// event handlers
    void	timerEvent( QTimerEvent * );
    void	mousePressEvent( QMouseEvent * );

private slots:					// internal slots
    void	stopDate();
    void	showTime();

private:					// internal data
    void	showDate();

    bool	showingColon;
    int		normalTimer;
    int		showDateTimer;
};


#endif // DCLOCK_H
