#include <qpainter.h>

#include "WidgetFrame.h"
#include "WidgetLayout.h"

#define Inherited Frame

WidgetFrame::WidgetFrame( QWidget* 	parent,
			  const char*	name )
    :
    Inherited( parent, name ),
    actGrid( 1 )
{
}


WidgetFrame::~WidgetFrame()
{
}


void WidgetFrame::paintEvent( QPaintEvent *theEvent )
{
    QFrame::paintEvent( theEvent );

	// No grid, no action
    if( actGrid >= 2 )
    {
	QPainter painter;
	painter.begin( this );
	for( int x = actGrid; x < this->width(); x += actGrid )
	    for( int y = actGrid; y < this->height(); y += actGrid )
	    {
		painter.drawPoint( x, y );
	    }
	painter.end();
    }
    
    emit Paint( this );
}

void WidgetFrame::SetGrid( int grid )
{
	// Never accept < 1
	if( grid < 1 )
		grid = 1;
	
	actGrid = grid;

	repaint();
}



