#ifndef BoxStretch_included
#define BoxStretch_included

#include "layout/LayoutItem.h"

#include "widget/Frame.h"

class BoxStretch : public LayoutItem
{
public: // Methods

    BoxStretch
    (
	QWidget*	parent,
	WidgetLayout*	widgetLayout,
	int		stretch = 1
    );
    
    virtual ~BoxStretch();
    
    virtual LayoutItem* FindLayoutItem
    (
	QWidget*	widget
    ) const;
    // Given the widget representing a layout item, return the item or NULL if
    // not found

    virtual void AddToLayout
    (
	QBoxLayout*	layout
    );
    // Add the item to the layout

    virtual void LowerWidget( void );
    // Lower all the widgets representing layout items

    virtual void SaveContents( QTextStream&	stream,
			       QString		id ) const;
    // Save the item's contents to the stream with the given id

    virtual bool RestoreKeyValue( const QString&	key,
				  const QString&	value );
    // Restore a single key/value pair

    virtual void GenerateSource( QTextStream&	stream,
				 const QString&	layoutVarName,
				 const QString&	layoutId ) const;
    // Generate the source for the layout given by layoutVarName.  If the 
    // layoutVarName is empty, the layout is a top level layout

    virtual QString GetItemName( void ) const;
    // Return a text string for the name of this item

    static QString ItemName( void );
    // Static method to return the name of this item

    virtual QRect GetGlobalGeometry( void ) const;
    // Get the global geometry for this layout item

    virtual QWidget* GetPropertyPage
    (
	QWidget*	parent
    );
    // Return a new property page to be used for this item

    int GetStretch( void ) const;
    
    void SetStretch
    (
	int	stretch
    );
    // Get/Set methods on the stretch

private: // Methods

    BoxStretch();
    BoxStretch( const BoxStretch& );
    BoxStretch& operator= ( const BoxStretch& );
    
private: // Attributes

    Frame*	itsFrame;
    // Frame that reperesents the stretch

    int		itsStretch;
    // Amount of stretch for the item
};


inline QString BoxStretch::ItemName( void )
{
    return "Box_Stretch";
}


inline int BoxStretch::GetStretch( void ) const
{
    return itsStretch;
}


inline void BoxStretch::SetStretch
(
    int	stretch
)
{
    itsStretch = stretch;
}


#endif // BoxStretch_included
