#include <qlayout.h>

#include "ColorFrame.h"
#include "prop/ColorSelectDialog.h"

ColorButton::ColorButton( QWidget *p, const QColor &c )
  : QPushButton( p )
{
  ChangeColor( this, c );
}

void ColorButton::mousePressEvent( QMouseEvent *e )
{
  emit ColorClicked( e->button(), this );
  QPushButton::mousePressEvent( e );
}

EditButton::EditButton( const QString &text, QWidget *p )
  : QPushButton( text, p )
{
}

void EditButton::mousePressEvent( QMouseEvent *e )
{
  emit Clicked( e->button() );
  QPushButton::mousePressEvent( e );
}

inline void AddButton( QWidget *p, const QColor &c, QBoxLayout *l )
{
  QWidget *tmp = new ColorButton( p, c );
  QObject::connect( tmp, SIGNAL(ColorClicked(int,QWidget *)),
           p, SLOT(ColorClicked(int,QWidget *)) );
  l->addWidget( tmp );
}

ColorFrame::ColorFrame( QWidget *parent )
  : QFrame( parent )
{
  QBoxLayout *layout = new QBoxLayout( this, QBoxLayout::Down );

  QBoxLayout *tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  tmpLayout->addWidget( leftColor = new QLabel( "Left", this ) );
  leftColor->setAlignment( AlignCenter );
  tmpLayout->addSpacing( 3 );
  tmpLayout->addWidget( rightColor = new QLabel( "Right", this ) );
  rightColor->setAlignment( AlignCenter );
  layout->addSpacing( 3 );

  tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  AddButton( this, white, tmpLayout );
  AddButton( this, red, tmpLayout );
  AddButton( this, darkRed, tmpLayout );

  tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  AddButton( this, lightGray, tmpLayout );
  AddButton( this, magenta, tmpLayout );
  AddButton( this, darkMagenta, tmpLayout );

  tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  AddButton( this, gray, tmpLayout );
  AddButton( this, blue, tmpLayout );
  AddButton( this, darkBlue, tmpLayout );

  tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  AddButton( this, darkGray, tmpLayout );
  AddButton( this, green, tmpLayout );
  AddButton( this, darkGreen, tmpLayout );

  tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  AddButton( this, black, tmpLayout );
  AddButton( this, yellow, tmpLayout );
  AddButton( this, darkYellow, tmpLayout );

  tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  AddButton( this, white, tmpLayout );
  AddButton( this, cyan, tmpLayout );
  AddButton( this, darkCyan, tmpLayout );

  tmpLayout = new QBoxLayout( QBoxLayout::LeftToRight );
  layout->addLayout( tmpLayout );

  editButton = new EditButton( "Edit...", this );
  connect( editButton, SIGNAL(Clicked(int)), this, SLOT(EditColor(int)) );
  editButton->setEnabled( FALSE );
  tmpLayout->addWidget( editButton );

  layout->activate();
}

void ColorFrame::ColorClicked( int button, QWidget *w )
{
  const QColor &c = w->backgroundColor();

  if( button == LeftButton )
    leftColor->setBackgroundColor( c );
  else if( button == RightButton )
    rightColor->setBackgroundColor( c );

  lastColorClicked = w;
  editButton->setEnabled( TRUE );

  emit ColorChanged( button, c );
}

void ColorFrame::EditColor( int button )
{
  const QColor &c = button == LeftButton ? leftColor->backgroundColor() :
    rightColor->backgroundColor();

  ColorSelectDialog *dlg = 
    new ColorSelectDialog( c, this );
  
  if( dlg->exec() )
  {
    const QColor &c = dlg->GetColor();

    ChangeColor( lastColorClicked, c );
    (button == LeftButton ? 
     leftColor : rightColor )->setBackgroundColor( c );
    emit ColorChanged( button, c );
  }
    
  delete dlg;
}
