#include <qpushbt.h> 

#include "PushButtonPage.h"

#include "widget/DlgWidget.h"

#define Inherited PushButtonPageData

PushButtonPage::PushButtonPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    const QPushButton* button = (const QPushButton*)widget->GetWidget();
	
    itsText->setText( button->text() );
    isAutoRepeat->setChecked( button->autoRepeat() );
    isAutoResize->setChecked( button->autoResize() );
    isToggleButton->setChecked( button->isToggleButton() );
    isDefault->setChecked( button->isDefault() );
    isAutoDefault->setChecked( button->autoDefault() );
}


PushButtonPage::~PushButtonPage()
{
}


void PushButtonPage::Apply( DlgWidget*	widget )
{
    QPushButton* button = (QPushButton*)widget->GetWidget();
    
    button->setText( itsText->text() );
    button->setAutoRepeat( isAutoRepeat->isChecked() );
    button->setAutoResize( isAutoResize->isChecked() );
    button->setToggleButton( isToggleButton->isChecked() );
    button->setDefault( isDefault->isChecked() );
    button->setAutoDefault( isAutoDefault->isChecked() );
}
