#include "widget/DlgMenuBar.h"
#include "widget/DlgFrame.h"

#include "prop/FramePage.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgMenuBar::itsSignals;
int DlgMenuBar::itsNextWidgetNum = 1;

DlgMenuBar::DlgMenuBar
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_MenuBar, parent )
{
    itsWidget = new MenuBar( parent, CreateName( "MenuBar", name, 
						 itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgMenuBar::~DlgMenuBar()
{
}


void DlgMenuBar::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new FramePage( this, parent, "Frame" ) );

    labels.append( "Frame" );
}


void DlgMenuBar::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nMenuBar {";
  
    DlgMenuBar::SaveQt( stream, (const QMenuBar *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgMenuBar::SaveQt
(
    QTextStream &,//stream,
    const QMenuBar *//widget
)
{
  // Nothing to do
}

bool DlgMenuBar::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgMenuBar::RestoreQt( key, value, (QMenuBar *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgMenuBar::RestoreQt
(
    const QString &,//key,
    const QString &,//value,
    QMenuBar *//widget
)
{
  // Nothing to do
  return FALSE;
}  


void DlgMenuBar::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );
}


void DlgMenuBar::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgMenuBar::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "activated(int)" );
	itsSignals.append( "highlighted(int)" );
    }

    return itsSignals;
}
