#include <toad/toad.hh>
#include <toad/combobox.hh>
#include <toad/listbox.hh>

class TMyWindow: public TWindow
{
		typedef TWindow super;
	public:
		TMyWindow(TWindow* p, const string& t);
};

int ToadMain()
{
	return TMyWindow(NULL,"ComboBox eXperiment").Run();
}

template <class T>
class GLAText:
	public TLBAdapter
{
	public:
		unsigned ItemHeight() {
			return TOADBase::DefaultFont().Height();
		}
		void PrintItem(int x, int y, unsigned item, TPen &pen) {
			if (item<ItemCount())
				pen.DrawString(x, y, Item(item));
		}
		virtual const T Item(unsigned) const = 0;
};

template <class T>
class GLATextVector:
	public GLAText<T>
{
		vector<T> *data;
	public:
		GLATextVector(vector<T> *d):data(d){}
		unsigned ItemCount() {
			if (!data) return 0;
			return data->size();
		}
		const T Item(unsigned n) const {
			return (*data)[n];
		}
};

TMyWindow::TMyWindow(TWindow* p, const string& t):
	super(p, t)
{
	static vector<string> data;
	data.push_back("The Spider");
	data.push_back("The Toad");
	data.push_back("The Cauldron");

	TListBox *lb1;
	lb1 = new TListBox(this, "listbox1", (TLBAdapter*)0);
	lb1->SetAdapter(new GLATextVector<string>(&data));
	lb1->SetShape(5,5,310,190);
	
	
#if 0
	TComboBox *cb1;
	cb1 = new TComboBox(this, "combobox1", (TLBAdapter*)0);
	cb->SetShape(5,5,200,TSIZE_PREVIOUS);
#endif
}
