/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toad.hh>
#include <toad/dialog.hh>
#include <toad/pushbutton.hh>

class TMyWindow:
	public TWindow
{
	public:
		TMyWindow(TWindow *p, const string &t);
		void click(int);
};

int ToadMain()
{
  return TMyWindow(NULL, "Window Placement").Run();
}

TMyWindow::TMyWindow(TWindow *p, const string &t):
	TWindow(p,t)
{
	static const char* name[] = {
		"screen center",
		"screen random",
		"parent center",
		"parent random",
		"mouse pointer"
	};
	for(int i=0; i<5; i++) {
		TPushButton *btn = new TPushButton(this, name[i]);
			btn->SetShape(5,5+25*i,150,20);
			CONNECT(btn->sigActivate, this, click, i);
	}
	
	SetSize(150+10, 5*25+5);
	bStaticFrame = true;
}

void TMyWindow::click(int mode)
{
	TDialog dlg(this, "Close Me");
	dlg.SetSize(50,50);
	dlg.SetCenterMode((EWindowPlacement)mode);
	dlg.DoModal();
}
