/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/checkbox.hh>

//! TCheckBox
//. A checkbox is a small control that can be toggled on and off.
//. <H3>Attention</H3>
//. Don't confuse this with Motifs XmCheckBox.

#define FENSTER95

// Constructor
//---------------------------------------------------------------------------
TCheckBox::TCheckBox(TWindow *parent, const string &title)
	:super(parent,title)
{
	_Init();
}

TCheckBox::~TCheckBox()
{
}

void TCheckBox::_Init()
{
	SetBackground(TColor::DIALOG);
	_data = false;
	SetBorder(false);
}

// value changed
//---------------------------------------------------------------------------
void TCheckBox::valueChanged()
{
	UpdateWindow();
}

// paint
//---------------------------------------------------------------------------
void TCheckBox::paint()
{
	TPen pen(this);
	int height;

	pen.SetColor(255,255,255);
	if (Enabled()) {
		pen.FillRectangle(2,2,9,9);
	}
	pen.Draw3DRectangle(0,0,13,13);

	if (Enabled()) {
		pen.SetColor(0,0,0);
		height = pen.DrawTextWidth(20,0, Label(),_w-20);
	} else {
		pen.SetColor(TColor::BTNLIGHT);
		pen.DrawTextWidth(21,1, Label(),_w-20);
		pen.SetColor(TColor::BTNSHADOW);
		height = pen.DrawTextWidth(20,0, Label(),_w-20);
	}

	if (_data) {
		pen.DrawLine(3,3,9,9);
		pen.DrawLine(3,4,8,9);
		pen.DrawLine(4,3,9,8);
		pen.DrawLine(9,3,3,9);
		pen.DrawLine(8,3,3,8);
		pen.DrawLine(9,4,4,9);
	}
		
	if (IsFocus()) {
		pen.SetLineStyle(TPen::DOT);
		pen.DrawRectangle(18,0,_w-18,height);
	}	else {
		pen.SetColor(TColor::DIALOG);
		pen.DrawRectangle(18,0,_w-18,height);
	}
}

// mouseLDown
//---------------------------------------------------------------------------
void TCheckBox::mouseLDown(int,int,unsigned)
{
	if (!Enabled())
		return;
	_data = !_data;
	SetFocus();
	UpdateWindow();
	ValueChanged();
}

// keyDown
//---------------------------------------------------------------------------
void TCheckBox::keyDown(TKey key, char* str, unsigned modifier)
{
	if (!modifier && (key==TK_RETURN || *str==' ')) {
		_data = !_data;
		SetFocus();
		UpdateWindow();
		ValueChanged();
	}
}
