/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996,97 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/rowcolumn.hh>
#include <toad/pulldown.hh>
#include <toad/menubar.hh>

//+---------------------------------------------------------------------------+
//| constructor                                                               |
//+---------------------------------------------------------------------------+
TPulldown::TPulldown(TWindow *parent, const string &title)
	:TRowColumn(parent,title)
{
	bPopup = bSaveUnder = true;
	nOrientation = TS_VERTICAL;
	active_button = NULL;
}

//+---------------------------------------------------------------------------+
//| Open                                                                      |
//+---------------------------------------------------------------------------+
void TPulldown::Open(int x,int y)
{
	SetPosition(x,y);
	Create();
// printf("TPulldown.Open: '%s' at %i,%i and size %i,%i\n",Title(),x,y,nWidth,nHeight);
}

//+---------------------------------------------------------------------------+
//| Close                                                                     |
//+---------------------------------------------------------------------------+
void TPulldown::Close()
{
//printf("TPulldown.Close: '%s'\n",sTitle());
	Destroy();
	SetActive(NULL);
}

//+---------------------------------------------------------------------------+
//| SetFirstActive                                                            |
//+---------------------------------------------------------------------------+
void TPulldown::SetFirstActive()
{
	if (FirstChild() && !IsActive() )
		SetActive((TMenuItem*)FirstChild());
}

//+---------------------------------------------------------------------------+
//| SetActive                                                                 |
//+---------------------------------------------------------------------------+
void TPulldown::SetActive(TMenuItem *btn)
{
	if (active_button)
	{
		active_button->Deactivate();
	}
	active_button=btn;
	if (active_button)
		active_button->Activate();
}
