/*
 * $XConsortium: system.h,v 1.4 89/09/19 14:43:58 jim Exp $
 *
 * Perfmon Performance Monitor
 *
 * Copyright 1985, Massachusetts Institute of Technology
 * Copyright 1989 PCS Computer Systeme GmbH, West Germany
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of PCS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  PCS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * PCS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL PCS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Original Author:  Emanuel Jay Berkenbilt, MIT Project Athena
 * Author:           Thomas A. Baghli, PCS Computer Systeme GmbH, West Germany
 *                   tom@meepmeep.pcs.com
 * Copyright 1994, Roger Smith for Sterling Software and NASA-Ames Research Center
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of NASA and Sterling Software (collectively 
 * or individually) are not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  NASA and Sterling Software makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * NASA & STERLING SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL NASA & STERLING SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * 1994 Revision
 * Author:           Roger Smith, Sterling Software @ NASA-Ames Research Center
 *                   Moffett Field, California, rsmith@proteus.arc.nasa.gov
 */

#include "version.h"

#define TRUE	1
#define FALSE	0


/* This file information needed by both system.c and Perfmon.c */


#define LINES_PER_LABEL 2

#ifdef PCS
#define CPUSTATES	4
#define DK_NDRIVE	4
#define NBPG		4096

#define USER		0
#define NICE		1
#define SYS		2
#define IDLE		3
#endif PCS

#define FORALLPOSSIBLESTATS(stat) \
    for (stat = 0; stat < NUM_POSSIBLE_STATS; stat++)
#define FORALLSTATS(stat) \
    for (stat = 0; stat < num_stats; stat++)

#define	NO_STAT			-1
#define USER_CPU_PERCENTAGE	1
#define SYSTEM_CPU_PERCENTAGE	2
#define IDLE_CPU_PERCENTAGE	3
#define FREE_MEM		4
#define DISK_TRANSFERS		10
#define INTERRUPTS		11
#define INPUT_PACKETS		14
#define OUTPUT_PACKETS		15
#define COLLISION_PACKETS	16
/*SC
#define NFS_CLIENT_CALLS        17
#define NFS_SERVER_CALLS        18
SC*/

struct statistic {
    int min_val, max_val;
    int value;
    char *label[LINES_PER_LABEL];
};


/* For setting and adjusting the timer. */

#define HUNDRED 100

/* These are passed to adjust_timeout() and represent
 * numbers of seconds.
 */
#define LARGE_ADD_TIME HUNDRED/10
#define LARGE_SUBTRACT_TIME -LARGE_ADD_TIME
#define SMALL_ADD_TIME LARGE_ADD_TIME/10
#define SMALL_SUBTRACT_TIME -SMALL_ADD_TIME
#define MAX_TIME 3 * HUNDRED /* five minutes */

#define VALID_UPDATE(x) ((x <= MAX_TIME) && (x > 0))

#define LOAD_AVG_PER_SEC False
#define USR_CPU_PER_SEC False
#define SYS_CPU_PER_SEC False
#define IDL_CPU_PER_SEC False
#define FRE_MEM_PER_SEC False
#define FREE_SWAP_PER_SEC False
/*SC
#define SWAP_IN_PER_SEC True
#define SWAP_OUT_PER_SEC True
#define PAGE_IN_PER_SEC True
#define PAGE_OUT_PER_SEC True
#define DSK_XFR_PER_SEC True
#define INTRPTS_PER_SEC False
#define PROCESSES_PER_SEC True
SC*/
#define SWAP_IN_PER_SEC False
#define SWAP_OUT_PER_SEC False
#define PAGE_IN_PER_SEC False
#define PAGE_OUT_PER_SEC False
#define DSK_XFR_PER_SEC False
#define INTRPTS_PER_SEC True
#define PROCESSES_PER_SEC False
/*SC
#define CPU_SWITCH_PER_SEC False
SC*/
#define CPU_SWITCH_PER_SEC True
#define INP_PKT_PER_SEC False
#define OUT_PKT_PER_SEC False
#define COL_PKT_PER_SEC False
/*SC
#define NFS_CLT_PER_SEC True
#define NFS_SRV_PER_SEC True
SC*/

#define LOAD_AVG 0
#define USR_CPU 1
#define SYS_CPU 2
#define IDL_CPU 3
#define FRE_MEM 4
#define FREE_SWAP 5
#define SWAP_IN 6
#define SWAP_OUT 7
#define PAGE_IN 8
#define PAGE_OUT 9
#define DSK_XFR 10
#define INTRPTS 11
#define PROCESSES 12
#define CPU_SWITCH 13
#define INP_PKT 14
#define OUT_PKT 15
#define COL_PKT 16

/*SC
#define NFS_CLT 17
#define NFS_SRV 18
#define LAST_ITEM NFS_SRV
SC*/
#define LAST_ITEM COL_PKT	/* must equal last item above */
#define NUM_GRAPHS LAST_ITEM +1

#define NUM_POSSIBLE_STATS     NUM_GRAPHS
#define MAX_STATS NUM_POSSIBLE_STATS + 1

typedef struct statistic stat_type[MAX_STATS];

#define FIRST_GROUP_ITEM LAST_ITEM +1
#define NFS_GROUP FIRST_GROUP_ITEM
#define NET_GROUP NFS_GROUP +1
#define SYS_GROUP NET_GROUP +1
#define PAGE_GROUP SYS_GROUP +1
#define SWAP_GROUP PAGE_GROUP +1
#define CPU_GROUP SWAP_GROUP +1
#define LAST_GROUP_ITEM CPU_GROUP
#define NUM_GROUPS LAST_GROUP_ITEM -LAST_ITEM +1

#define HELP_GENERAL 0
#define HELP_GRAPHS 1
#define HELP_GROUPS 2
#define HELP_ALARMS 3

/* data structure for custom application resources */
typedef struct {
    XtAppContext app_context;
    Widget toplevel;
    Bool stuf1,stuf2;
    int interval;		/* update interval */
    int count;			/* nothing (yet) */
    Boolean fast;		/* when set, interval is in milliseconds */
    int ms_per_sec;		/* interval multiplier, set to 1 if fast is true */
    Boolean fill;		/* draw filled graph when set, else draw line graph */
    Boolean debug;		/* control debug output */
    Bool addG[NUM_GRAPHS+NUM_GROUPS];
    Bool subG[NUM_GRAPHS+NUM_GROUPS];
    Bool graphOn[NUM_GRAPHS];
    Bool helpReq[4];
    Dimension numGraphsOn;	/* number of graphs on and running for this invocation */
    XtIntervalId interval_id;	/* timeout interval id */
}AppData, *AppDataPtr;

static Bool perSec[] = {
    LOAD_AVG_PER_SEC,
    USR_CPU_PER_SEC,
    SYS_CPU_PER_SEC,
    IDL_CPU_PER_SEC,
    FRE_MEM_PER_SEC,
    FREE_SWAP_PER_SEC,
    SWAP_IN_PER_SEC,
    SWAP_OUT_PER_SEC,
    PAGE_IN_PER_SEC,
    PAGE_OUT_PER_SEC,
    DSK_XFR_PER_SEC,
    INTRPTS_PER_SEC,
    PROCESSES_PER_SEC,
    CPU_SWITCH_PER_SEC,
    INP_PKT_PER_SEC,
    OUT_PKT_PER_SEC,
    COL_PKT_PER_SEC,
/*SC
    NFS_CLT_PER_SEC,
    NFS_SRV_PER_SEC,
SC*/
};
static char *topNames[] = {
    "Load Avg",
    "User",
    "System",
    "Idle",
    "Free",
    "Free",
    "Pages",
    "Pages",
    "Kilobytes",
    "Kilobytes",
    "Disk",
    "Interrupts",
    "Processes",
    "Context",
    "Input",
    "Output",
    "Collision",
/*SC
    "NFS Client",
    "NFS Server",
SC*/
};
static char *widgetLabels[] = {
    "Load",
    "User",
    "System",
    "Idle",
    "FreeMem",
    "FreeSwap",
    "SwapIn",
    "SwapOut",
    "PageIn",
    "PageOut",
    "Disk",
    "Intrpts",
    "Processes",
    "CpuSwitch",
    "Input",
    "Output",
    "Collision",
/*SC
    "NFSClient",
    "NFSServer",
SC*/
};
static char *botNames[] = {
    "x100",
    "CPU %",
    "CPU %",
    "CPU %",
    "Memory",
    "Swap",
    "Swapped In",
    "Swapped Out",
    "Paged In",
    "Paged Out",
    "Transfers",
    "",
    "",
    "Switches",
    "Packets",
    "Packets",
    "Packets",
/*SC
    "Calls",
    "Calls",
SC*/
};
