./" .TH XPERFMON++ 1 "19 January 1988" "X Version 11"
.TH XPERFMON++ 1 "January 1994" "X Version 11"
.SH NAME
xperfmon++ - X Window System-based performance monitor
.SH SYNOPSIS
.B xperfmon++
[\-\fItoolkitoption\fP ...] [\-\fIadditionaloption\fP ...]
.SH DESCRIPTION
.I xperfmon++
continuously displays multiple system statistics as a set of parallel
line graphs.
The name of the host is displayed in the upper left hand corner.
Immediately under the hostname, the update interval is displayed.
The information is scaled so that it always fills the window regardless of geometry changes.
.PP
The \fIxperfmon++\fP application is based on  highly modified Athena StripChart
Widgets. (The original \fPxerfmon\fP used a custom private Widget.)
All scrolling action is smooth, i.e., one pixel at a time, and the scale
labels are updated immediately on plotting a new point outside a previous scale range.
The program can produce a filled graph or a line graph and the update interval can be set in
seconds or 100-millisecond intervals.
.PP
While 
.I xperfmon++
is running, it is possible to perform certain tasks by pressing keys over
the window:
.PP
.br
.B Q/q: 
Quit... Exit gracefully
.br
.B l | L: 
Print out a chart of all current limit settings. This chart will appear in the
window from which xperfmon++ was invoked.
.br
.B d | D: 
Toggle debugging printout on or off
.br
.B s: 
Decrease update interval (slower) by a small amount
.br
.B S: 
Decrease update interval (slower) by a large amount
.br
.B f: 
Increase update interval (faster) by a small amount
.br
.B F: 
Increase update interval (faster) by a large amount
.br
.B ?: 
Help
.SH OPTIONS
.PP
.I xperfmon++
accepts all of the standard X Toolkit command line options along with the
following additional options:
.PP
.TP 8
.B \-interval \fIseconds\fP
This options specifies the update interval for the graph.
The default is 1. The interpretation of this option is modified by the \fIfast\fP option.
.PP
.TP 8
.B \-fast
This option modifies the meaning of the \fIupdate\fP option.
When \fI-fast\fP is specified, the update interval is modified to specify
\fImilliseconds\fP. Otherwise, the update interval specifies \fIseconds\fP.
When running in \fIfast\fP mode, the minimum update interval is 100 milliseconds.
.PP
.TP 8
.B \-fill
This option controls the type of graph produced. When \fI-fill\fP is specified the
program produces a filled graph, otherwise a line graph is generated.
.PP
.TP 8
.B \-immediate
This option controls what the {high|low} limit {alarms|warnings} are based on. When set, the
limit {alarms|warnings} are based on the current data sample only. When not set, (the default)
the limits are based on the {min|max} value present in the viewable graph.
.SH GRAPHING OPTIONS
.PP
The following options specify the list of statistics to be displayed.
If none are present on the command line, then all statistics are displayed.
If any "+" options are listed the default list is cleared and only those 
listed as "+" options are displayed.
If any "-" options are listed, then they are taken away from the
default list. Specifying both "-" and "+" options will produce unpredictable
results.
.TP 26
.B \-usercpu | \+usercpu
Graph percentage of \fIUser CPU Time\fP.
.TP 26
.B \-systemcpu  | \+systemcpu
Graph \fISystem\fP CPU Percentage.
.TP 26
.B \-idlecpu | \+idlecpu
Graph \fIIdle\fP CPU Percentage.
.TP 26
.B \-freemem | \+freemem
Graph \fIFree Memory\fP.
.TP 26
.B \-freeswap | \+freeswap
Graph \fIFree Swap\fP space.
.TP 26
.B \-swapin | \+swapin
Graph \fIMemory Pages Swapped In\fP.
.TP 26
.B \-swapout | \+swapout
Graph \fIMemory Pages Swapped Out\fP.
.TP 26
.B \-pagein | \+pagein
Graph \fIMemory Pages Paged In\fP.
.TP 26
.B \-pageout | \+pageout
Graph \fIMemory Pages Paged Out\fP.
.TP 26
.B \-cpuswitch | \+cpuswitch
Graph \fIContext Switches\fP.
.TP 26
.B \-diskxfr | \+diskxfr
Graph \fIDisk Transfers\fP per interval period.
.TP 26
.B \-interrputs | \+interrupts
Graph \fISystem Interrupts\fP.
.TP 26
.B \-inputpkts | \+inputpkts
Graph number of network \fIInput Packets\fP.
.TP 26
.B \-outputpkts | \+outputpkts
Graph number of network \fIOutput packets\fP.
.TP 26
.B \-collpkts | \+collpkts
Graph number of network \fICollision Packets\fP.
.TP 26
.B \-processes | \+processes
Graph Number of \fIactive processes\fP in the system.
.TP 26
.B \-loadavg | \+loadavg
Graph the \fILoad Average\fP (x100).
.SH LIMIT OPTIONS
.PP
.sp
\fIxperfmon++\fP will accept a number of \fIlimit\fP options. When a data point
exceeds a high or low limit the background of that graph changes color to visually reflect
the condition. The background color is an indication of the min (low limit) or max (high limit) 
value currently contained
in the graph. When no limit has been exceeded the background color is set to green. If no limits have
been set for that graph its background color remains the same as the applications default color, 
which is usually white. 
.PP
WARNING: High and Low limits are mutually exclusive, i.e., you can set high limits or low limits, but
not both. If both are inadvertently set, the high limits are checked first, and the low limit will be
ignored.
.PP
There are four possible \fIlimit\fP conditions:
.TP 16
.B High Warning
When any value in the current graph exceeds the  \fIhigh warning\fP limit 
the background color of that graph is changed to \fIyellow\fP.
.TP 16
.B Low Warning
When any value in the current graph is less than the \fIlow warning\fP limit
the background color of that graph is changed to \fIyellow\fP.
.TP 16
.B High Alarm
When any value in the current graph exceeds the \fIhigh alarm\fP limit the
background color of that graph is changed to \fIred\fP.
.TP 16
.B Low Alarm
When any value in the current graph is less that the \fIlow alarm\fP limit the
background color of that graph is changed to \fIred\fP.
.PP
\fILimits\fP can be set with command line options or with application resources.
The syntax of setting a \fIlimit\fP option from the command line is (Note: \fICase\fP IS sensitive):
.TP 26
.B \-low*Alarm \fIvalue\fP
Set low Alarm value for *.
.TP 26
.B \-low*Warn \fIvalue\fP
Set low Warning value for *.
.TP 26
.B \-high*Alarm \fIvalue\fP
Set high Alarm value for *.
.TP 26
.B \-high*Warn \fIvalue\fP
Set high Warning value for *.
.PP 
Where "*" is one of the following:
.TP 12
.B loadavg
Set \fIlimit\fP value for Load Average.
.TP 12
.B user
Set \fIlimit\fP value for User CPU Percentage.
.TP 12
.B sys
Set \fIlimit\fP value for System CPU Percentage.
.TP 12
.B idle
Set \fIlimit\fP value for Idle CPU Percentage.
.TP 12
.B mem
Set \fIlimit\fP value for Free Memory.
.TP 12
.B swapin
Set \fIlimit\fP value for Pages Swapped In.
.TP 12
.B swapout
Set \fIlimit\fP value for Pages Swapped Out.
.TP 12
.B pagein
Set \fIlimit\fP value for Kilobytes Paged In.
.TP 12
.B pageout
Set \fIlimit\fP value for Kilobytes Paged Out.
.TP 12
.B disk
Set \fIlimit\fP value for Disk Transfers.
.TP 12
.B intrpts
Set \fIlimit\fP value for System Interrupts.
.TP 12
.B processes
Set \fIlimit\fP value for Processes.
.TP 12
.B cpuswitch
Set \fIlimit\fP value for Context Switches.
.TP 12
.B input
Set \fIlimit\fP value for network Input Packets.
.TP 12
.B output
Set \fIlimit\fP value for network Output Packets.
.TP 12
.B collision
Set \fIlimit\fP value for network Collision Packets.
.TP 12
.PP
For example:
.TP 16
.B \-lowuserA 25
Set \fIlow user Alarm\fP value to 25.
.PP
As with any X-based command line specification you only need specify the minimum number of
characters required to make the string unique. 
See below for a description of setting \fIlimit\fP values using application resource specifications.
.SH TOOLKIT OPTIONS
.PP
.sp
The following standard X Toolkit arguments are commonly used
with \fIxperfmon++\fP:
.PP
.TP 8
.B \-d | \-display \fIdisplay\fP
This option specifies the X server to contact.
.PP
.TP 8
.B \-g | \-geometry \fIgeometry\fP
The xperfmon++ window is created with the specified size and location
determined by the supplied geometry specification.
See \fIX(1)\fP for a full explanation.
.PP
.TP 8
.B \-bd | \-bordercolor \fIcolor\fP
This option specifies the border color.
The default is \fIblack\fP.
.PP
.TP 8
.B \-bg | \-background \fIcolor\fP
This option specifies the background color.
The default is \fIwhite\fP.
.PP
.TP 8
.B \-bw | \-borderwidth \fIpixels\fP
This option specifies the width in pixels of the border around the window.
The default value is 2.
.PP
.TP 8
.B \-fg | \-foreground \fIcolor\fP
This option specifies the foreground color.
The default color is \fIblack\fP.
.PP
.TP 8
.B \-fn | \-font \fIfontname\fP
This options specifies the font to be used in displaying the hostname and
labels.
The default is
\fI6X10\fP.
.PP
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.
This is especially useful for setting resources that do not have
separate command line options.
.SH "X DEFAULTS"
.PP
.I xperfmon++
understands all of the core resource names and
classes as well as:
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the load average graph.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the load average graph.
.TP 8
.B update (\fPclass\fB Interval)
Specifies the frequency in seconds at which the performance statistics
should be redisplayed.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the color for the foreground.
The default is \fIblack\fP since the core default for background
is \fIwhite\fP.
.TP 8
.B font (\fPclass\fB Font)
Specifies the font to be used for the label.  The default is \fIfixed\fP.
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
Specifies that the foreground and background should be reversed.
.SH LIMIT RESOURCES
To set a limit that applies to all active graphs use the class name as in the following syntax:
.TP 26
.B *PerfChart.{lowAlarm|lowWarn|highAlarm|highWarn}
Individual graph \fIlimit\fP alarm and warning values can be set with resource specifications.
.PP
To set a limit that applies to any individual graph use the following syntax:
.TP 26
.B *perfChart&.lowAlarm:
\fIvalue\fP
.TP 26
.B *perfChart&.lowWarn:
\fIvalue\fP
.TP 26
.B *perfChart&.highAlarm:
\fIvalue\fP
.TP 26
.B *perfChart&.highWarn:
\fIvalue\fP
.PP
Where "&" is one of the following (Note: \fICase\fP IS important):
.TP 16
.B Idle
Set Idle CPU Percentage resource.
.TP 16
.B User
Set User CPU Percentage resource.
.TP 16
.B System
Set System CPU Percentage resource.
.TP 16
.B Free
Set Free Memory resource.
.TP 16
.B FreeSwap
Set Free Swap resource.
.TP 16
.B SwapIn
Set Pages Swapped In resource.
.TP 16
.B SwapOut
Set Pages Swapped Out resource.
.TP 16
.B PageIn
Set Kilobytes Paged In resource.
.TP 16
.B PageOut
Set Kilobytes Paged Out resource.
.TP 16
.B Disk
Set Disk Transfer count resource.
.TP 16
.B Intrpts
Set System Interrupts resource.
.TP 16
.B CpuSwitch
Set Context Switches resource.
.TP 16
.B Processes
Set Context Switches resource.
.TP 16
.B Input
Set network Input Packets resource.
.TP 16
.B Output
Set network Output Packets resource.
.TP 16
.B Collision
Set network Collision Packets resource.
.PP
For example:
.TP 29
.B *perfChartIdle.lowAlarm: 25
Set \fIlow Idle Alarm\fP (Idle CPU Percentage) value to 25.
.PP
There is a sample Application Defaults file included in the distribution
called \fIXperfmon++.ad\fP. Copy this file to your private directory and
edit it to your hearts content. Then load it into xrbd with a command like:
.TP 8
.B xrdb -m Xperfmon++.ad
.SH ENVIRONMENT VARIABLES
DISPLAY - specifies the default host and display number.
.SH SEE ALSO
X(1), uwm(1), xload(1), mem(4)
.SH BUGS
.I xperfmon++
requires the ability to open and read the special system file
.I /dev/kmem. 
On most systems, this requires the
.I suid
(set user id) bit to be set with root ownership, or the
.I sgid
(set group id) bit to be set and membership in the same group as 
.I /dev/kmem. 
.PP
Reading /dev/kmem is inherently non-portable.  Therefore, the widget upon
which this application is based must be ported to each new operating system.
.PP
There is a known bug in the refresh logic that occassionally occurs when a partially occluded
xperfmon++ window is partially or fully exposed. This is manifested in the redraw
logic overwriting some or all of one or more graphs, and/or the timestamps. It can be corrected
by fully covering the xperfmon++ window and then exposing it, or by iconifying the
xperfmon++ window and then de-iconifying it.
.SH AUTHORS
The X11 version of 
.I xperfmon
was written by Emanuel Jay Berkenbilt, Project Athena on
1/21/1988.
There is no record of previous authors.
.PP
.I xperfmon
was modified by Thomas Bagli, PCS Computer Systeme GmbH, West Germany, to
be a toolkit-based client.
.PP
.I xperfmon+
was created from \fIxperfmon\fP, and the Athena StripChart Widget,
by Roger Smith, Sterling Software @ NASA-Ames Research Center, Moffett Field, California. 
Version 1.0 was released in January, 1994.
.PP
.I xperfmon++
was created from /fIxperfmon+/fP, by Roger Smith in February, 1994. Much thanks to Georg Feil
<georg@sgl.ists.ca> for his diff file to print current value labels, and to correct minor problems
with the hi and low scale values.
.PP
Updated for Linux by scoffin@netcom.com, 3/96.
.PP
If you like this program, or if you have difficulties, I would like to hear your comments.
E-Mail me at rsmith@proteus.arc.nasa.gov. If you add any enhancements, as Georg did, email them to
me and I will include them into the master distribution along with credits for your efforts.
.PP
.I xperfmon++ 
was written for Suns running SunOs and DEC systems running ULTRIX, using X11R5 Windows software. If some energetic soul
out there would like to port this program to any other operating system or architecture I would be
glad to incorporate the modifications into this master copy. Send me your changes via E-Mail at the
above address.
.PP
Enjoy!
