/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)IllegalThreadStateException.java	1.11 95/08/11  
 *
 */

package java.lang;

/**
 * Exception indicating that a thread is not in the proper state for the
 * requested operation.
 * @see	Thread#suspend
 * @see	Thread#resume
 * @version 	1.11, 08/11/95
 */
public class IllegalThreadStateException extends IllegalArgumentException {
    /**
     * Constructs an IllegalThreadStateException with no detail message.
     * A detail message is a String that describes this particular exception.
     */
    public IllegalThreadStateException() {
	super();
    }

    /**
     * Constructs an IllegalThreadStateException with the specified detail message.
     * A detail message is a String that describes this particular exception.
     * @param s the detail message
     */
    public IllegalThreadStateException(String s) {
	super(s);
    }
}
