/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.PrintJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.awt.motif.PSGraphics;
import sun.awt.motif.PSPrintJob;
import sun.awt.motif.PrintControl;
import sun.awt.motif.PrintStatusDialog;
import sun.awt.motif.UPrintDialog;

public class PSPrintControl
implements PrintControl {
    public static final String DEST_PROP = "awt.print.destination";
    public static final String PRINTER = "printer";
    public static final String FILE = "file";
    public static final String PRINTER_PROP = "awt.print.printer";
    public static final String FILENAME_PROP = "awt.print.fileName";
    public static final String NUMCOPIES_PROP = "awt.print.numCopies";
    public static final String OPTIONS_PROP = "awt.print.options";
    public static final String ORIENT_PROP = "awt.print.orientation";
    public static final String PORTRAIT = "portrait";
    public static final String LANDSCAPE = "landscape";
    public static final String PAPERSIZE_PROP = "awt.print.paperSize";
    public static final String LETTER = "letter";
    public static final String LEGAL = "legal";
    public static final String EXECUTIVE = "executive";
    public static final String A4 = "a4";
    private static ResourceBundle messageRB;
    private UPrintDialog printDialog;
    private Frame parentFrame;
    private String destStr;
    private String copiesStr;
    private String bannerStr;
    private String orientStr;
    private String paperStr;
    private String printerName;
    private String fileName;
    private String lpOptions;
    private int destType = 0;
    private int orient = 1;
    private int paperSize = 0;
    private int numCopies = 1;

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.printcontrol");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is missing.");
        }
    }

    static String getMsg(String string) {
        if (messageRB == null) {
            PSPrintControl.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is broken, There is no " + string + " key in resource");
        }
    }

    public PSPrintControl(Frame frame) {
        this.printDialog = new UPrintDialog(frame, "Print Dialog");
        this.parentFrame = frame;
    }

    public PSPrintJob initJob(String string, Properties properties, boolean bl) {
        PSPrintJob pSPrintJob = null;
        this.readProps(properties);
        this.printDialog.setDocumentTitle(string);
        this.printDialog.setNumCopies(this.numCopies);
        this.printDialog.setDestType(this.destType);
        this.printDialog.setDestString(0, this.printerName != null ? this.printerName : "lp");
        this.printDialog.setDestString(1, this.fileName != null ? this.fileName : "");
        this.printDialog.setOptionsString(this.lpOptions != null ? this.lpOptions : "");
        this.printDialog.setBannerString(string);
        this.printDialog.setOrientation(this.orient);
        this.printDialog.setPaperSize(this.paperSize);
        pSPrintJob = (PSPrintJob)this.printDialog.getPrintJob(this);
        if (pSPrintJob != null && bl) {
            this.writeProps(properties);
        }
        return pSPrintJob;
    }

    public PrintJob createPrintJob(int n, String string, String string2, String string3, int n2, int n3, int n4) {
        Serializable serializable;
        OutputStream outputStream = null;
        String[] stringArray = new String[1];
        String string4 = null;
        this.destType = n;
        this.bannerStr = string3;
        this.numCopies = n4;
        this.orient = n3;
        switch (n) {
            case 0: {
                this.printerName = string;
                this.lpOptions = string2;
                try {
                    stringArray = this.printExecCmd(string, string2, string3, n4);
                    Process process = Runtime.getRuntime().exec(stringArray);
                    outputStream = process.getOutputStream();
                }
                catch (IOException iOException) {
                    string4 = String.valueOf(PSPrintControl.getMsg("error_msg.exec_print")) + stringArray;
                }
                break;
            }
            case 1: {
                this.fileName = string;
                serializable = new File(this.fileName);
                String string5 = "";
                try {
                    string5 = ((File)serializable).getCanonicalPath();
                    if (((File)serializable).exists()) {
                        String string6 = PSPrintControl.getMsg("warning_button.cancel");
                        String string7 = PSPrintControl.getMsg("warning_button.overwrite");
                        PrintStatusDialog printStatusDialog = new PrintStatusDialog(this.parentFrame, PSPrintControl.getMsg("warning_dialog.title"), String.valueOf(PSPrintControl.getMsg("warning_msg.file_exists")) + this.fileName, string7, string6);
                        printStatusDialog.show();
                        if (printStatusDialog.getCommand().equals(string6)) {
                            return null;
                        }
                    }
                    outputStream = new FileOutputStream((File)serializable);
                }
                catch (IOException iOException) {
                    string4 = String.valueOf(PSPrintControl.getMsg("error_msg.create_file")) + string5;
                }
                break;
            }
            default: {
                return null;
            }
        }
        if (string4 != null) {
            serializable = new PrintStatusDialog(this.parentFrame, PSPrintControl.getMsg("error_dialog.title"), string4, PSPrintControl.getMsg("error_button.ok"));
            ((Dialog)serializable).show();
            return null;
        }
        switch (n2) {
            case 1: {
                serializable = PSGraphics.Legal;
                break;
            }
            case 2: {
                serializable = PSGraphics.Executive;
                break;
            }
            case 3: {
                serializable = PSGraphics.A4;
                break;
            }
            default: {
                serializable = PSGraphics.Letter;
            }
        }
        if (n3 == 0) {
            serializable = new Dimension(((Dimension)serializable).height, ((Dimension)serializable).width);
        }
        return new PSPrintJob(new PrintStream(new BufferedOutputStream(outputStream), false), string3, (Dimension)serializable, 72);
    }

    private void readProps(Properties properties) {
        if (properties == null) {
            return;
        }
        this.destStr = properties.getProperty(DEST_PROP);
        if (this.destStr != null) {
            this.destType = this.destStr.equals(FILE) ? 1 : 0;
        }
        this.printerName = properties.getProperty(PRINTER_PROP);
        this.fileName = properties.getProperty(FILENAME_PROP);
        this.lpOptions = properties.getProperty(OPTIONS_PROP);
        this.orientStr = properties.getProperty(ORIENT_PROP);
        if (this.orientStr != null) {
            int n = this.orient = this.orientStr.equals(LANDSCAPE) ? 0 : 1;
        }
        if ((this.paperStr = properties.getProperty(PAPERSIZE_PROP)) != null) {
            if (this.paperStr.equals(LETTER)) {
                this.paperSize = 0;
            } else if (this.paperStr.equals(LEGAL)) {
                this.paperSize = 1;
            } else if (this.paperStr.equals(EXECUTIVE)) {
                this.paperSize = 2;
            } else if (this.paperStr.equals(A4)) {
                this.paperSize = 3;
            }
        }
        if ((this.copiesStr = properties.getProperty(NUMCOPIES_PROP)) != null) {
            Integer n = new Integer(this.copiesStr);
            this.numCopies = n;
        }
    }

    private void writeProps(Properties properties) {
        if (properties == null) {
            return;
        }
        properties.put(DEST_PROP, this.destType == 0 ? PRINTER : FILE);
        if (this.printerName != null && !this.printerName.equals("") && !this.printerName.equals("lp")) {
            properties.put(PRINTER_PROP, this.printerName);
        }
        if (this.fileName != null && !this.fileName.equals("")) {
            properties.put(FILENAME_PROP, this.fileName);
        }
        if (this.lpOptions != null && !this.lpOptions.equals("")) {
            properties.put(OPTIONS_PROP, this.lpOptions);
        }
        properties.put(ORIENT_PROP, this.orient == 1 ? PORTRAIT : LANDSCAPE);
        switch (this.paperSize) {
            case 1: {
                this.paperStr = LEGAL;
                break;
            }
            case 2: {
                this.paperStr = EXECUTIVE;
                break;
            }
            case 3: {
                this.paperStr = A4;
                break;
            }
            default: {
                this.paperStr = LETTER;
            }
        }
        properties.put(PAPERSIZE_PROP, this.paperStr);
        if (this.numCopies > 0) {
            properties.put(NUMCOPIES_PROP, new Integer(this.numCopies).toString());
        }
    }

    private String[] printExecCmd(String string, String string2, String string3, int n) {
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n6 |= n2;
            ++n7;
        }
        if (string2 != null && !string2.equals("")) {
            n6 |= n3;
            ++n7;
        }
        if (string3 != null && !string3.equals("")) {
            n6 |= n4;
            ++n7;
        }
        if (n > 1) {
            n6 |= n5;
            ++n7;
        }
        String[] stringArray = new String[n7];
        stringArray[n8++] = "/usr/bin/lp";
        if ((n6 & n2) != 0) {
            stringArray[n8++] = new String("-d" + string);
        }
        if ((n6 & n4) != 0) {
            stringArray[n8++] = new String("-t" + string3);
        }
        if ((n6 & n5) != 0) {
            stringArray[n8++] = new String("-n" + new Integer(n).toString());
        }
        if ((n6 & n3) != 0) {
            stringArray[n8++] = new String("-o" + string2);
        }
        return stringArray;
    }
}

