/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;

class LightweightDispatcher
implements Serializable {
    private static final long serialVersionUID = 5184291520170872969L;
    private Container nativeContainer;
    private Component focus;
    private transient Component mouseEventTarget;
    private boolean dragging;
    private Cursor nativeCursor;
    private long eventMask;
    private static final long PROXY_EVENT_MASK = 60L;
    private static final long MOUSE_MASK = 48L;

    LightweightDispatcher(Container container) {
        this.nativeContainer = container;
        this.focus = null;
        this.mouseEventTarget = null;
        this.eventMask = 0L;
    }

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    boolean setFocusRequest(Component component) {
        boolean bl = true;
        Window window = this.nativeContainer.getWindow();
        if (window != null && component != null) {
            Component component2 = window.getFocusOwner();
            if (component2 == this.nativeContainer) {
                this.focus = component;
                component.dispatchEvent(new FocusEvent(component, 1004, false));
                bl = false;
            } else if (component2 == component) {
                this.focus = component;
                bl = false;
            } else if (component2 == this.focus) {
                if (this.focus != null) {
                    this.focus.dispatchEvent(new FocusEvent(this.focus, 1005, false));
                }
                this.focus = component;
                component.dispatchEvent(new FocusEvent(component, 1004, false));
                bl = false;
            }
        }
        return bl;
    }

    boolean dispatchEvent(AWTEvent aWTEvent) {
        if ((this.eventMask & 0x3CL) != 0L) {
            if (aWTEvent instanceof MouseEvent && (this.eventMask & 0x30L) != 0L) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                return this.processMouseEvent(mouseEvent);
            }
            if (aWTEvent instanceof FocusEvent) {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                return this.processFocusEvent(focusEvent);
            }
            if (aWTEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                return this.processKeyEvent(keyEvent);
            }
        }
        return false;
    }

    private boolean processKeyEvent(KeyEvent keyEvent) {
        if (this.focus != null) {
            KeyEvent keyEvent2 = new KeyEvent(this.focus, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
            this.focus.dispatchEvent(keyEvent2);
            return true;
        }
        return false;
    }

    private boolean processFocusEvent(FocusEvent focusEvent) {
        if (this.focus != null) {
            int n = focusEvent.getID();
            FocusEvent focusEvent2 = new FocusEvent(this.focus, n, focusEvent.isTemporary());
            this.focus.dispatchEvent(focusEvent2);
            if (n == 1005 && !focusEvent.isTemporary()) {
                this.focus = null;
            }
            return true;
        }
        return false;
    }

    private boolean processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (this.mouseEventTarget != null) {
            switch (n) {
                case 506: {
                    this.retargetMouseEvent(n, mouseEvent);
                    break;
                }
                case 501: {
                    this.dragging = true;
                    this.retargetMouseEvent(n, mouseEvent);
                    break;
                }
                case 502: {
                    this.dragging = false;
                    this.retargetMouseEvent(n, mouseEvent);
                    Component component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY());
                    if (component == this.mouseEventTarget) break;
                    this.setMouseTarget(component, mouseEvent);
                    break;
                }
                case 500: {
                    this.retargetMouseEvent(n, mouseEvent);
                    break;
                }
                case 504: {
                    this.retargetMouseEvent(n, mouseEvent);
                    break;
                }
                case 505: {
                    if (this.dragging) {
                        this.retargetMouseEvent(n, mouseEvent);
                        break;
                    }
                    this.setMouseTarget(null, mouseEvent);
                    break;
                }
                case 503: {
                    Component component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY());
                    if (component != this.mouseEventTarget) {
                        this.setMouseTarget(component, mouseEvent);
                    }
                    if (this.mouseEventTarget == null) break;
                    this.retargetMouseEvent(n, mouseEvent);
                    break;
                }
            }
            mouseEvent.consume();
        } else {
            Component component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY());
            if (component != null) {
                this.setMouseTarget(component, mouseEvent);
                if (n != 504) {
                    this.retargetMouseEvent(n, mouseEvent);
                }
                mouseEvent.consume();
            }
        }
        return mouseEvent.isConsumed();
    }

    void setMouseTarget(Component component, MouseEvent mouseEvent) {
        if (this.mouseEventTarget != null) {
            this.retargetMouseEvent(505, mouseEvent);
        } else {
            this.nativeCursor = this.nativeContainer.getCursor();
        }
        this.mouseEventTarget = component;
        if (this.mouseEventTarget != null) {
            this.retargetMouseEvent(504, mouseEvent);
            return;
        }
        this.nativeContainer.setCursor(this.nativeCursor);
    }

    void retargetMouseEvent(int n, MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Component component = this.mouseEventTarget;
        while (component != null && component != this.nativeContainer) {
            n2 -= component.x;
            n3 -= component.y;
            component = component.getParent();
        }
        if (component != null) {
            MouseEvent mouseEvent2 = new MouseEvent(this.mouseEventTarget, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            this.mouseEventTarget.dispatchEvent(mouseEvent2);
            if (this.mouseEventTarget != null) {
                Cursor cursor = this.mouseEventTarget.getCursor();
                if (this.nativeContainer.getCursor() != cursor) {
                    this.nativeContainer.setCursor(cursor);
                }
            }
        }
    }
}

