/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final long julianDayOffset = 2440588L;
    private static final int millisPerDay = 86400000;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;
    private static final int[] MONTH_LENGTH;
    private static final int[] LEAP_MONTH_LENGTH;
    private long gregorianCutover = -12219292800000L;
    private static long JULIAN_ONSET;
    private static long EARLIEST_USABLE_MILLIS;
    private static int EARLIEST_USABLE_YEAR;
    private static final int[] MinValues;
    private static final int[] GreatestMinValues;
    private static final int[] LeastMaxValues;
    private static final int[] MaxValues;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    static final long serialVersionUID = -8125100834729963327L;

    private static final long millisToJulianDay(long l) {
        if (l >= 0L) {
            return 2440588L + l / 86400000L;
        }
        return 2440588L + (l - 86400000L + 1L) / 86400000L;
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    private static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private final void timeToFields(long l) {
        int n;
        int n2;
        long l2;
        long l3;
        int n3 = 1;
        if (l < EARLIEST_USABLE_MILLIS) {
            throw new IllegalArgumentException("GregorianCalendar does not handle dates before 4716 BC");
        }
        long l4 = l3 = l >= 0L ? 2440588L + l / 86400000L : 2440588L + (l - 86400000L + 1L) / 86400000L;
        if (l >= this.gregorianCutover) {
            long l5 = (long)(((double)(l3 - 1867216L) - 0.25) / 36524.25);
            l2 = l3 + 1L + l5 - (long)(0.25 * (double)l5);
        } else {
            l2 = l3;
        }
        long l6 = l2 + 1524L;
        long l7 = (long)(6680.0 + ((double)(l6 - 2439870L) - 122.1) / 365.25);
        long l8 = (long)((double)(365L * l7) + 0.25 * (double)l7);
        long l9 = (long)((double)(l6 - l8) / 30.6001);
        int n4 = (int)(l6 - l8 - (long)(30.6001 * (double)l9));
        int n5 = (int)l9 - 1;
        if (n5 > 12) {
            n5 -= 12;
        }
        int n6 = (int)(l7 - 4715L);
        if (n5 > 2) {
            --n6;
        }
        if (n6 <= 0) {
            n3 = 0;
            n6 = 1 - n6;
        }
        this.fields[0] = n3;
        this.fields[1] = n6;
        this.fields[2] = n2 = n5 - 1;
        this.fields[5] = n4;
        this.fields[7] = n = GregorianCalendar.julianDayToDayOfWeek(l3);
        int n7 = this.isLeapYear(n6) ? LEAP_NUM_DAYS[n5 - 1] + n4 : NUM_DAYS[n5 - 1] + n4;
        this.fields[6] = n7;
        this.fields[3] = n2 = this.weekNumber(n7, n);
        this.fields[4] = n2 = this.weekNumber(n4, n);
        this.fields[8] = n2 = (n4 - 1) / 7 + 1;
    }

    private int weekNumber(int n, int n2) {
        int n3 = (n2 - this.getFirstDayOfWeek() - n + 1) % 7;
        if (n3 < 0) {
            n3 += 7;
        }
        int n4 = (n + n3 - 1) / 7;
        if (7 - n3 >= this.getMinimalDaysInFirstWeek()) {
            ++n4;
        }
        return n4;
    }

    public boolean isLeapYear(int n) {
        long l = (long)((double)(n - 1970) * 365.2422 * 8.64E7);
        if (l < JULIAN_ONSET) {
            return false;
        }
        if (l > this.gregorianCutover) {
            return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        }
        return n % 4 == 0;
    }

    protected void computeFields() {
        int n;
        int n2;
        if (this.areFieldsSet) {
            return;
        }
        int n3 = this.getTimeZone().getRawOffset();
        long l = this.time + (long)n3;
        this.timeToFields(l);
        int n4 = this.fields[0];
        int n5 = this.fields[1];
        int n6 = this.fields[2];
        int n7 = this.fields[5];
        int n8 = this.fields[7];
        long l2 = l / 86400000L;
        int n9 = (int)(l - l2 * 86400000L);
        if (n9 < 0) {
            n9 += 86400000;
        }
        if ((n9 += (n2 = this.getTimeZone().getOffset(n4, n5, n6, n7, n8, n9) - n3)) >= 86400000) {
            n9 -= 86400000;
            this.timeToFields(l += (long)n2);
        }
        this.fields[14] = n = n9 % 1000;
        this.fields[13] = n = (n9 /= 1000) % 60;
        this.fields[12] = n = (n9 /= 60) % 60;
        this.fields[11] = n9 /= 60;
        this.fields[9] = n = n9 / 12;
        this.fields[10] = n = n9 % 12;
        this.fields[15] = n3;
        this.fields[16] = n2;
        this.userSetZoneOffset = false;
        this.userSetDSTOffset = false;
        this.areFieldsSet = true;
        this.areAllFieldsSet = true;
        n = 0;
        while (n < 17) {
            this.isSet[n] = true;
            ++n;
        }
    }

    boolean inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.fields[16] != 0;
    }

    private final int monthLength(int n, int n2) {
        if (this.isLeapYear(n2)) {
            return LEAP_MONTH_LENGTH[n];
        }
        return MONTH_LENGTH[n];
    }

    private boolean validateFields() {
        int n;
        block10: {
            block12: {
                block11: {
                    int n2 = 0;
                    while (n2 < 17) {
                        if (n2 != 5 && n2 != 6 && this.isSet[n2] && ((n = this.fields[n2]) < this.getMinimum(n2) || n > this.getMaximum(n2) && !false)) {
                            return false;
                        }
                        ++n2;
                    }
                    if (!this.isSet[5]) break block10;
                    n = this.fields[5];
                    if (n < this.getMinimum(5)) break block11;
                    int n3 = this.fields[2];
                    int n4 = this.fields[1];
                    if (n <= (this.isLeapYear(n4) ? LEAP_MONTH_LENGTH[n3] : MONTH_LENGTH[n3])) break block12;
                }
                return false;
            }
            return true;
        }
        if (this.isSet[6]) {
            n = this.fields[6];
            if (this.isLeapYear(this.fields[1]) ? n < 1 || n > 366 : n < 1 || n > 365) {
                return false;
            }
        }
        if (this.isSet[1]) {
            n = this.fields[1];
            if (!this.isSet[0] || this.fields[0] == 1) {
                n = 1 - n;
            }
            if (n > EARLIEST_USABLE_YEAR) {
                return false;
            }
        }
        return !this.isSet[8] || this.fields[8] != 0;
    }

    private boolean boundsCheck(int n, int n2) {
        return n >= this.getMinimum(n2) && n <= this.getMaximum(n2);
    }

    protected void computeTime() {
        int n;
        int n2;
        long l;
        if (this.isTimeSet) {
            return;
        }
        boolean bl = this.areFieldsSet = !this.isLenient() && this.areAllFieldsSet;
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n3 = this.isSet[0] ? this.fields[0] : 1;
        if (n3 < 0 || n3 > 1) {
            throw new IllegalArgumentException();
        }
        int n4 = this.fields[1];
        int n5 = 0;
        int n6 = 0;
        if (n3 == 0) {
            n4 = 1 - n4;
        }
        long l3 = 0L;
        if (this.isSet[2] && (this.isSet[5] || this.isSet[7] && (this.isSet[4] || this.isSet[8]))) {
            n5 = this.fields[2] + 1;
            if (n5 < 1) {
                n4 += n5 / 12 - 1;
                n5 = 12 + n5 % 12;
            } else if (n5 > 12) {
                n4 += n5 / 12;
                n5 %= 12;
            }
            if (n5 > 2) {
                ++n5;
            } else {
                --n4;
                n5 += 13;
            }
            l3 = (long)(Math.floor(365.25 * (double)n4) + Math.floor(30.6001 * (double)n5) + 1720995.0);
            if (this.isSet[5]) {
                n6 = this.fields[5];
            } else {
                l = l3;
                if ((l3 - 2440588L) * 86400000L >= this.gregorianCutover) {
                    long l4 = (long)(0.01 * (double)n4);
                    l += 2L - l4 + (long)(0.25 * (double)l4);
                }
                if ((n2 = GregorianCalendar.julianDayToDayOfWeek(l + 1L) - this.getFirstDayOfWeek()) < 0) {
                    n2 += 7;
                }
                n6 = 1 - n2 + this.fields[7] - this.getFirstDayOfWeek();
                if (this.isSet[4]) {
                    if (7 - n2 < this.getMinimalDaysInFirstWeek()) {
                        n6 += 7;
                    }
                    n6 += 7 * (this.fields[4] - 1);
                } else {
                    if (n6 < 1) {
                        n6 += 7;
                    }
                    if ((n = this.fields[8]) >= 0) {
                        n6 += 7 * (n - 1);
                    } else {
                        int n7 = this.fields[2];
                        n6 += (((this.isLeapYear(n4) ? LEAP_MONTH_LENGTH[n7] : MONTH_LENGTH[n7]) - n6) / 7 + n + 1) * 7;
                    }
                }
            }
            l3 += (long)n6;
        } else if (this.isSet[6] || this.isSet[7] && this.isSet[3]) {
            l3 = (long)(Math.floor(365.25 * (double)(--n4)) + 428.0 + 1720995.0);
            if (this.isSet[6]) {
                l3 += (long)this.fields[6];
            } else {
                l = l3;
                if ((l3 - 2440588L) * 86400000L >= this.gregorianCutover) {
                    long l5 = (long)(0.01 * (double)n4);
                    l += 2L - l5 + (long)(0.25 * (double)l5);
                }
                if ((n2 = GregorianCalendar.julianDayToDayOfWeek(l + 1L) - this.getFirstDayOfWeek()) < 0) {
                    n2 += 7;
                }
                n6 = 1 - n2 + this.fields[7] - this.getFirstDayOfWeek();
                if (7 - n2 < this.getMinimalDaysInFirstWeek()) {
                    n6 += 7;
                }
                l3 += (long)(n6 += 7 * (this.fields[3] - 1));
            }
        } else {
            throw new IllegalArgumentException();
        }
        l2 = (l3 - 2440588L) * 86400000L;
        if (l2 >= this.gregorianCutover) {
            l = (long)(0.01 * (double)n4);
            l2 = ((l3 += 2L - l + (long)(0.25 * (double)l)) - 2440588L) * 86400000L;
        }
        int n8 = 0;
        if (this.isSet[11]) {
            n8 += this.fields[11];
        } else if (this.isSet[10]) {
            n8 += this.fields[10];
            n8 += 12 * this.fields[9];
        }
        n8 *= 60;
        n8 += this.fields[12];
        n8 *= 60;
        n8 += this.fields[13];
        n8 *= 1000;
        TimeZone timeZone = this.getTimeZone();
        n2 = this.isSet[15] && this.userSetZoneOffset ? this.fields[15] : timeZone.getRawOffset();
        l2 += (long)(n8 += this.fields[14]);
        n = 0;
        if (this.isSet[16] && this.userSetDSTOffset) {
            n = this.fields[16];
        } else {
            if (!this.isSet[2] || !this.isSet[5]) {
                this.timeToFields(l2);
            }
            n = timeZone.getOffset(n3, this.fields[1], this.fields[2], this.fields[5], GregorianCalendar.julianDayToDayOfWeek(l3), n8) - n2;
        }
        this.time = l2 - (long)n2 - (long)n;
        this.isTimeSet = true;
    }

    public synchronized int hashCode() {
        return this.getFirstDayOfWeek() ^ this.getMinimalDaysInFirstWeek();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        return this.getTimeInMillis() == gregorianCalendar.getTimeInMillis() && this.isLenient() == gregorianCalendar.isLenient() && this.getFirstDayOfWeek() == gregorianCalendar.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == gregorianCalendar.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(gregorianCalendar.getTimeZone());
    }

    public boolean before(Object object) {
        if (this == object || object == null || !(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        return this.getTimeInMillis() < gregorianCalendar.getTimeInMillis();
    }

    public boolean after(Object object) {
        if (this == object || object == null || !(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        return this.getTimeInMillis() > gregorianCalendar.getTimeInMillis();
    }

    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.complete();
        if (n == 1) {
            int n3 = this.fields[1];
            if (this.fields[0] == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                    return;
                }
                this.set(1, 1 - n3);
                this.set(0, 0);
                return;
            }
            if ((n3 -= n2) > 0) {
                this.set(1, n3);
                return;
            }
            this.set(1, 1 - n3);
            this.set(0, 1);
            return;
        }
        if (n == 2) {
            int n4 = this.fields[2] + n2;
            if (n4 >= 0) {
                this.add(1, n4 / 12);
                this.set(2, n4 % 12);
                return;
            }
            this.add(1, (n4 + 1) / 12 - 1);
            if ((n4 %= 12) < 0) {
                n4 += 12;
            }
            this.set(2, n4);
            return;
        }
        if (n == 0) {
            int n5 = this.fields[0] + n2;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > 1) {
                n5 = 1;
            }
            this.set(0, n5);
            return;
        }
        long l = this.fields[16];
        long l2 = n2;
        switch (n) {
            case 3: 
            case 4: 
            case 8: {
                l2 *= 604800000L;
                break;
            }
            case 9: {
                l2 *= 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                l2 *= 86400000L;
                break;
            }
            case 10: 
            case 11: {
                l2 *= 3600000L;
                break;
            }
            case 12: {
                l2 *= 60000L;
                break;
            }
            case 13: {
                l2 *= 1000L;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
            case 14: 
        }
        this.setTimeInMillis(this.time + l2);
        l -= (long)this.fields[16];
        if (l2 != 0L) {
            this.setTimeInMillis(this.time + l);
        }
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    void roll(int n, int n2) {
        int n3;
        if (n2 == 0) {
            return;
        }
        this.complete();
        int n4 = this.getMinimum(n);
        int n5 = this.getMaximum(n);
        switch (n) {
            case 3: {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13 = this.fields[7] - this.getFirstDayOfWeek();
                if (n13 < 0) {
                    n13 += 7;
                }
                if ((n12 = (n13 - this.fields[6] + 1) % 7) < 0) {
                    n12 += 7;
                }
                if ((n11 = (this.fields[6] + n2 * 7 - (n10 = 7 - n12 < this.getMinimalDaysInFirstWeek() ? 8 - n12 : 1 - n12)) % (n9 = (n8 = (n7 = this.isLeapYear(this.fields[1]) ? 366 : 365) + 7 - (n6 = (n7 - this.fields[6] + n13) % 7)) - n10)) < 0) {
                    n11 += n9;
                }
                if ((n11 += n10) < 1) {
                    n11 = 1;
                }
                if (n11 > n7) {
                    n11 = n7;
                }
                this.set(6, n11);
                this.clear(2);
                return;
            }
            case 4: {
                int n14;
                int n15 = this.fields[7] - this.getFirstDayOfWeek();
                if (n15 < 0) {
                    n15 += 7;
                }
                if ((n14 = (n15 - this.fields[5] + 1) % 7) < 0) {
                    n14 += 7;
                }
                int n16 = 7 - n14 < this.getMinimalDaysInFirstWeek() ? 8 - n14 : 1 - n14;
                int n17 = this.fields[2];
                int n18 = this.fields[1];
                n17 = this.isLeapYear(n18) ? LEAP_MONTH_LENGTH[n17] : MONTH_LENGTH[n17];
                int n19 = n17 + 7 - (n18 = (n17 - this.fields[5] + n15) % 7);
                int n20 = n19 - n16;
                int n21 = (this.fields[5] + n2 * 7 - n16) % n20;
                if (n21 < 0) {
                    n21 += n20;
                }
                if ((n21 += n16) < 1) {
                    n21 = 1;
                }
                if (n21 > n17) {
                    n21 = n17;
                }
                this.set(5, n21);
                return;
            }
            case 5: {
                n3 = this.fields[2];
                int n22 = this.fields[1];
                n5 = this.isLeapYear(n22) ? LEAP_MONTH_LENGTH[n3] : MONTH_LENGTH[n3];
                break;
            }
            case 6: {
                long l = (long)n2 * 86400000L;
                long l2 = this.time - (long)(this.fields[6] - 1) * 86400000L;
                int n23 = this.isLeapYear(this.fields[1]) ? 366 : 365;
                this.time = (this.time + l - l2) % ((long)n23 * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)n23 * 86400000L;
                }
                this.setTimeInMillis(this.time + l2);
                return;
            }
            case 7: {
                long l = (long)n2 * 86400000L;
                int n24 = this.fields[7] - this.getFirstDayOfWeek();
                if (n24 < 0) {
                    n24 += 7;
                }
                long l3 = this.time - (long)n24 * 86400000L;
                this.time = (this.time + l - l3) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                this.setTimeInMillis(this.time + l3);
                return;
            }
            case 8: {
                long l = (long)n2 * 604800000L;
                int n25 = (this.fields[5] - 1) / 7;
                int n26 = this.fields[2];
                int n27 = this.fields[1];
                n26 = ((this.isLeapYear(n27) ? LEAP_MONTH_LENGTH[n26] : MONTH_LENGTH[n26]) - this.fields[5]) / 7;
                long l4 = this.time - (long)n25 * 604800000L;
                long l5 = 604800000L * (long)(n25 + n26 + 1);
                this.time = (this.time + l - l4) % l5;
                if (this.time < 0L) {
                    this.time += l5;
                }
                this.setTimeInMillis(this.time + l4);
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
        }
        int n28 = n5 - n4 + 1;
        n3 = this.fields[n] + n2;
        n3 = (n3 - n4) % n28;
        if (n3 < 0) {
            n3 += n28;
        }
        this.set(n, n3 += n4);
    }

    public int getMinimum(int n) {
        return MinValues[n];
    }

    public int getMaximum(int n) {
        return MaxValues[n];
    }

    public int getGreatestMinimum(int n) {
        return GreatestMinValues[n];
    }

    public int getLeastMaximum(int n) {
        return LeastMaxValues[n];
    }

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        NUM_DAYS = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        LEAP_NUM_DAYS = nArray2;
        MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        JULIAN_ONSET = -62893584000000L;
        EARLIEST_USABLE_MILLIS = -210993120000000L;
        EARLIEST_USABLE_YEAR = 4716;
        int[] nArray3 = new int[17];
        nArray3[1] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = -1;
        nArray3[15] = -43200000;
        MinValues = nArray3;
        int[] nArray4 = new int[17];
        nArray4[1] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[8] = -1;
        nArray4[15] = -43200000;
        GreatestMinValues = nArray4;
        LeastMaxValues = new int[]{1, 5000000, 11, 53, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
        MaxValues = new int[]{1, 5000000, 11, 54, 6, 31, 366, 7, 6, 1, 12, 23, 59, 59, 999, 43200000, 3600000};
    }
}

