/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final long serialVersionUID = -403250971215465050L;

    public SimpleTimeZone(int n, String string) {
        this.rawOffset = n;
        this.setID(string);
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setID(string);
        this.rawOffset = n;
        this.startMonth = n2;
        this.startDay = n3;
        this.startDayOfWeek = n4;
        this.startTime = n5;
        this.endMonth = n6;
        this.endDay = n7;
        this.endDayOfWeek = n8;
        this.endTime = n9;
        this.useDaylight = true;
    }

    public void setStartYear(int n) {
        this.startYear = n;
        this.useDaylight = true;
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = n3;
        this.startTime = n4;
        this.useDaylight = true;
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = n3;
        this.endTime = n4;
        this.useDaylight = true;
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.rawOffset;
        if (n2 < this.startYear || n != 1) {
            return n7;
        }
        boolean bl = this.startMonth > this.endMonth;
        int n8 = SimpleTimeZone.compareToRule(n3, n4, n5, n6, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int n9 = SimpleTimeZone.compareToRule(n3, n4, n5, n6 + 3600000, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        if (!bl && n8 >= 0 && n9 < 0 || bl && (n8 >= 0 || n9 < 0)) {
            n7 += 3600000;
        }
        return n7;
    }

    private static int compareToRule(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n < n5) {
            return -1;
        }
        if (n > n5) {
            return 1;
        }
        byte by = staticMonthLength[n];
        int n9 = n7 > 0 ? 1 + (n7 - 1) * 7 + (7 + n6 - (n3 - n2 + 1)) % 7 : by + (n7 + 1) * 7 - (7 + (n3 + by - n2) - n6) % 7;
        if (n2 < n9) {
            return -1;
        }
        if (n2 > n9) {
            return 1;
        }
        if (n4 < n8) {
            return -1;
        }
        if (n4 > n8) {
            return 1;
        }
        return 0;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this);
        gregorianCalendar.setTimeInMillis(date.getTime());
        return gregorianCalendar.inDaylightTime();
    }

    public Object clone() {
        return super.clone();
    }

    public synchronized int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        if (!this.getID().equals(simpleTimeZone.getID())) {
            return false;
        }
        if (this.startMonth != simpleTimeZone.startMonth) {
            return false;
        }
        if (this.startDay != simpleTimeZone.startDay) {
            return false;
        }
        if (this.startDayOfWeek != simpleTimeZone.startDayOfWeek) {
            return false;
        }
        if (this.startTime != simpleTimeZone.startTime) {
            return false;
        }
        if (this.endMonth != simpleTimeZone.endMonth) {
            return false;
        }
        if (this.endDay != simpleTimeZone.endDay) {
            return false;
        }
        if (this.endDayOfWeek != simpleTimeZone.endDayOfWeek) {
            return false;
        }
        if (this.endTime != simpleTimeZone.endTime) {
            return false;
        }
        if (this.startYear != simpleTimeZone.startYear) {
            return false;
        }
        if (this.rawOffset != simpleTimeZone.rawOffset) {
            return false;
        }
        return this.useDaylight == simpleTimeZone.useDaylight;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.startDayOfWeek == 0) {
            this.startDayOfWeek = 1;
        }
        if (this.endDayOfWeek == 0) {
            this.endDayOfWeek = 1;
        }
    }
}

