/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgIdDSA;
import sun.security.x509.X509Key;

public final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable {
    private static boolean debug;
    private BigInteger y;

    public DSAPublicKey() {
    }

    public DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public DSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.y = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            return;
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("could not DER encode y: " + iOException.getMessage());
        }
    }

    public BigInteger getY() {
        return this.y;
    }

    public DSAParams getParams() {
        return (DSAParams)((Object)this.algid);
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger().toBigInteger();
            return;
        }
        catch (IOException iOException) {
            DSAPublicKey.debug(iOException);
            throw new InvalidKeyException("Invalid key: y value\n" + iOException.getMessage());
        }
    }

    public String toString() {
        return "Sun DSA Public Key \nparameters:" + this.algid + "\ny: " + this.y.toString(16) + "\n";
    }

    private static void debug(Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
    }
}

