/*
 * Decompiled with CFR 0.152.
 */
package actual;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class OpenlookButton
extends Component {
    static int capWidth = 20;
    String label;
    protected boolean pressed = false;
    ActionListener actionListener;

    public OpenlookButton() {
        this("");
    }

    public OpenlookButton(String string) {
        this.label = string;
        this.enableEvents(16L);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        int n = this.getSize().width - 1;
        int n2 = this.getSize().height - 1;
        Color color3 = this.getBackground();
        if (this.pressed) {
            color2 = color3.darker();
            color = color3.brighter();
        } else {
            color2 = color3.brighter();
            color = color3.darker();
        }
        graphics.setColor(color3);
        graphics.fillArc(0, 0, capWidth, n2, 90, 180);
        graphics.fillArc(n - capWidth, 0, capWidth, n2, 270, 180);
        graphics.fillRect(capWidth / 2, 0, n - capWidth, n2);
        graphics.setColor(color2);
        graphics.drawLine(capWidth / 2, 0, n - capWidth / 2, 0);
        graphics.setColor(color);
        graphics.drawLine(capWidth / 2, n2, n - capWidth / 2, n2);
        graphics.setColor(color2);
        graphics.drawArc(0, 0, capWidth, n2, 90, 140);
        graphics.setColor(color);
        graphics.drawArc(0, 0, capWidth, n2, 230, 40);
        graphics.setColor(color2);
        graphics.drawArc(n - capWidth, 0, capWidth, n2, 50, 40);
        graphics.setColor(color);
        graphics.drawArc(n - capWidth, 0, capWidth, n2, 270, 140);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.setColor(this.getForeground());
            graphics.drawString(this.label, n / 2 - fontMetrics.stringWidth(this.label) / 2, n2 / 2 + fontMetrics.getHeight() / 2 - fontMetrics.getMaxDescent());
        }
    }

    public Dimension getPreferredSize() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            return new Dimension(fontMetrics.stringWidth(this.label) + capWidth * 2, fontMetrics.getHeight() + 10);
        }
        return new Dimension(100, 50);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 50);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.enableEvents(16L);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.pressed = true;
                this.repaint();
                break;
            }
            case 502: {
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
                }
                if (!this.pressed) break;
                this.pressed = false;
                this.repaint();
                break;
            }
            case 505: {
                if (!this.pressed) break;
                this.pressed = false;
                this.repaint();
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }
}

