/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int n) {
        this.buf = new char[n];
    }

    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            int n2 = this.count + 1;
            if (n2 > this.buf.length) {
                int n3 = this.buf.length << 1;
                char[] cArray = new char[n3 >= n2 ? n3 : n2];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            this.buf[this.count] = (char)n;
            this.count = n2;
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.count + n2;
            if (n3 > this.buf.length) {
                int n4 = this.buf.length << 1;
                char[] cArray2 = new char[n4 >= n3 ? n4 : n3];
                System.arraycopy(this.buf, 0, cArray2, 0, this.count);
                this.buf = cArray2;
            }
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count = n3;
            return;
        }
    }

    public void write(String string, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.count + n2;
            if (n3 > this.buf.length) {
                int n4 = this.buf.length << 1;
                char[] cArray = new char[n4 >= n3 ? n4 : n3];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            string.getChars(n, n + n2, this.buf, this.count);
            this.count = n3;
            return;
        }
    }

    public void writeTo(Writer writer) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            writer.write(this.buf, 0, this.count);
            return;
        }
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.buf, 0, cArray, 0, this.count);
            char[] cArray2 = cArray;
            Object var3_4 = null;
            return cArray2;
        }
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            String string = new String(this.toCharArray());
            Object var3_3 = null;
            return string;
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

