/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public int decimalAt;
    public int count;
    public byte[] digits = new byte[19];

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(int n) {
        if (this.count < 19) {
            this.digits[this.count] = (byte)n;
        }
        ++this.count;
    }

    public final double getDouble() {
        StringBuffer stringBuffer = new StringBuffer(this.count);
        if (this.count > 19) {
            this.count = 19;
        }
        int n = 0;
        while (n < this.count) {
            stringBuffer.append((char)this.digits[n]);
            ++n;
        }
        String string = new String(stringBuffer);
        long l = Long.parseLong(string, 10);
        return (double)l * Math.pow(10.0, this.decimalAt - this.count);
    }

    public final long getLong() {
        StringBuffer stringBuffer = new StringBuffer(this.count);
        int n = 0;
        while (n < this.count) {
            stringBuffer.append((char)this.digits[n]);
            ++n;
        }
        String string = new String(stringBuffer);
        return Long.parseLong(string, 10);
    }

    private int fixNumber(double d, StringBuffer stringBuffer, int n) {
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        double d4 = d;
        d2 = Math.log(d4);
        d3 = Math.log(10.0);
        double d5 = d2 / d3;
        n2 = (int)(d5 - 19.0);
        while (d4 > 9.223372036854776E18) {
            d4 /= 10.0;
            ++n3;
        }
        long l = (long)d4;
        String string = Long.toString(l, 10);
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            if (string.charAt(n4) != '0') break;
            --n4;
        }
        int n5 = 0;
        while (n5 < n4 + 1) {
            stringBuffer.append(string.charAt(n5));
            this.digits[n5] = (byte)string.charAt(n5);
            ++n5;
        }
        this.decimalAt = (int)((double)(n3 - n2) + d5 - (double)n);
        return n4 + 1;
    }

    public final void set(double d, int n) {
        int n2 = 0;
        double d2 = d * Math.pow(10.0, n);
        long l = (long)Math.floor(d2 + 0.5);
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(19);
        if (l < 0L) {
            this.count = this.fixNumber(d2, stringBuffer, n);
            bl = true;
        }
        if (!bl) {
            stringBuffer.append(Long.toString(l, 10));
            while (l > 0L && (double)l < Math.pow(10.0, n - 1)) {
                stringBuffer.insert(0, '0');
                l *= 10L;
            }
            n2 = stringBuffer.length() - 1;
            while (n2 >= 0) {
                if (stringBuffer.charAt(n2) != '0') break;
                --n;
                --n2;
            }
            this.count = n2 + 1;
            int n3 = 0;
            while (n3 < this.count) {
                this.digits[n3] = (byte)stringBuffer.charAt(n3);
                ++n3;
            }
            this.decimalAt = this.count - n;
        }
        if (this.decimalAt < 0) {
            this.decimalAt = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void set(long l) {
        int n;
        String string;
        if (l == Long.MIN_VALUE) {
            l = -(l + 1L);
            string = Long.toString(l, 10).substring(0, 18);
            n = Long.toString(l, 10).charAt(18);
            long l2 = Character.digit((char)n, 10) + 1;
            if (l2 > 9L) throw new InternalError("Internal NumberFormat error!");
            string = String.valueOf(string) + Long.toString(l2, 10);
        } else {
            string = Long.toString(l, 10);
        }
        if (string.length() > 19) {
            string = string.substring(0, 19);
        }
        int n2 = 0;
        n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) != '0') break;
            --n2;
            --n;
        }
        this.count = n + '\u0001';
        int n3 = 0;
        while (n3 < this.count) {
            this.digits[n3] = (byte)string.charAt(n3);
            ++n3;
        }
        this.decimalAt = this.count - n2;
        if (this.decimalAt >= 0) return;
        this.decimalAt = 0;
    }

    public Object clone() {
        try {
            return (DigitList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.hashCode() != digitList.hashCode()) {
            return false;
        }
        if (this.count != digitList.count) {
            return false;
        }
        if (this.digits.length != digitList.digits.length) {
            return false;
        }
        int n = 0;
        while (n < this.digits.length) {
            if (this.digits[n] != digitList.digits[n]) {
                return false;
            }
            ++n;
        }
        return this.decimalAt == digitList.decimalAt;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.digits.length) {
            short s = (short)(this.digits[n2] >> 16);
            short s2 = this.digits[n2];
            n ^= s ^ s2;
            ++n2;
        }
        return n;
    }

    DigitList() {
    }
}

