/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public final class System {
    private static Properties props = new Properties();
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static SecurityManager security;

    private System() {
    }

    private static native Properties initProperties(Properties var0);

    public static void setIn(InputStream inputStream) {
        if (security != null) {
            security.checkExec("setio");
        }
        if (inputStream == null) {
            throw new NullPointerException();
        }
        ((DelegatingInputStream)in).setDelegate(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        if (security != null) {
            security.checkExec("setio");
        }
        if (printStream == null) {
            throw new NullPointerException();
        }
        DelegatingPrintStream delegatingPrintStream = (DelegatingPrintStream)out;
        if (delegatingPrintStream != printStream) {
            if (delegatingPrintStream.ps != null) {
                delegatingPrintStream.ps.flush();
            }
            delegatingPrintStream.ps = printStream;
        }
    }

    public static void setErr(PrintStream printStream) {
        if (security != null) {
            security.checkExec("setio");
        }
        if (printStream == null) {
            throw new NullPointerException();
        }
        DelegatingPrintStream delegatingPrintStream = (DelegatingPrintStream)err;
        if (delegatingPrintStream != printStream) {
            if (delegatingPrintStream.ps != null) {
                delegatingPrintStream.ps.flush();
            }
            delegatingPrintStream.ps = printStream;
        }
    }

    private static void checkIO() {
        if (security != null) {
            security.checkExec("setio");
        }
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != null) {
            throw new SecurityException("SecurityManager already set");
        }
        security = securityManager;
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    public static Properties getProperties() {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        return props;
    }

    public static void setProperties(Properties properties) {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        props = properties;
    }

    public static String getProperty(String string) {
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string, string2);
    }

    public static String getenv(String string) {
        throw new Error("getenv no longer supported, use properties and -D instead: " + string);
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void load(String string) {
        Runtime.getRuntime().load(string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string);
    }

    static {
        System.initProperties(props);
        in = new DelegatingInputStream();
        out = new DelegatingPrintStream();
        err = new DelegatingPrintStream();
        security = null;
        System.setIn(new BufferedInputStream(new FileInputStream(FileDescriptor.in)));
        System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out), true));
        System.setErr(new PrintStream(new FileOutputStream(FileDescriptor.err), true));
    }

    private static final class DelegatingInputStream
    extends FilterInputStream {
        DelegatingInputStream() {
            super(null);
        }

        void setDelegate(InputStream inputStream) {
            if (this != inputStream) {
                this.in = inputStream;
            }
        }
    }

    private static final class DelegatingPrintStream
    extends PrintStream {
        private PrintStream ps;

        DelegatingPrintStream() {
            super(null);
        }

        void setDelegate(PrintStream printStream) {
            if (this != printStream) {
                if (this.ps != null) {
                    this.ps.flush();
                }
                this.ps = printStream;
            }
        }

        public void flush() {
            this.ps.flush();
        }

        public void close() {
            this.ps.close();
        }

        public boolean checkError() {
            return this.ps.checkError();
        }

        public void write(int n) {
            this.ps.write(n);
        }

        public void print(boolean bl) {
            this.ps.print(bl);
        }

        public void print(char c) {
            this.ps.print(c);
        }

        public void print(int n) {
            this.ps.print(n);
        }

        public void print(long l) {
            this.ps.print(l);
        }

        public void print(float f) {
            this.ps.print(f);
        }

        public void print(double d) {
            this.ps.print(d);
        }

        public void print(char[] cArray) {
            this.ps.print(cArray);
        }

        public void print(String string) {
            this.ps.print(string);
        }

        public void print(Object object) {
            this.ps.print(object);
        }

        public void println() {
            this.ps.println();
        }

        public void println(boolean bl) {
            this.ps.println(bl);
        }

        public void println(char c) {
            this.ps.println(c);
        }

        public void println(int n) {
            this.ps.println(n);
        }

        public void println(long l) {
            this.ps.println(l);
        }

        public void println(float f) {
            this.ps.println(f);
        }

        public void println(double d) {
            this.ps.println(d);
        }

        public void println(char[] cArray) {
            this.ps.println(cArray);
        }

        public void println(String string) {
            this.ps.println(string);
        }

        public void println(Object object) {
            this.ps.println(object);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.ps.write(byArray, n, n2);
        }
    }
}

