/*
 * @(#)AppFrame.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
/* Generic Full Application Frame
 * @(#)AppFrame.java	1.2  11/23/96 16:39:49
 * @author Kevin A. Smith
 *
 * The class AppFrame provides an  AWT Frame window for running
 * applications.  
 *
 */

import java.awt.Frame;
import java.awt.Event;
import java.awt.MenuItem;

// Application Frame window
class AppFrame extends Frame
{
    // constructor needed to pass window title to class Frame
/*    public AppFrame()
    {
       super("Untitled");
    }

 */
    public AppFrame(String name)
    {
       // call java.awt.Frame(String) constructor
       super(name);
    }

    // needed to allow window close
    public boolean handleEvent(Event e)
    {
       // Window Destroy event
       if (e.id == Event.WINDOW_DESTROY)
          return appExit(0);
       
       // it's good form to let the super class look at any 
       // unhandled events
       return super.handleEvent(e);

    }  // end handleEvent()

    // Generic Action event handler
    public boolean action(Event evt, Object obj)
    {
       if(evt.target instanceof MenuItem)
          return menuEvent(evt, obj);
       else
          // it is good form to let the super class look at any
          // unhandled events.
          return super.action(evt, obj);

    }  // end action()

    // Generic Menu event handler
    public boolean menuEvent(Event evt, Object obj)
    {
       String menuLabel = obj.toString();

       if( menuLabel.equals("Exit") )
       {
          // This menu item is the same as Close
          return appExit(0);
       }

       else
          // menu event handler did nothing with this event.
          // In a fully written application, you should never
          // get to this line.
          return false;

    }  // end menuEvent()

    protected boolean appExit(int exitCode)
    {
       System.exit(exitCode);
       return true;
    }
}   // end class AppFrame

