/*
 * @(#)KeyDownTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.applet.Applet;
import java.awt.*;

public class KeyDownTest extends Applet
{
    String sLastKey;
    boolean bSeenCR = false;

    public void init()
    {

       sLastKey = "None";       
       resize(200, 200);
    }

    public boolean keyDown(Event evt, int key)
    {
       switch (key)
       {
          case 10:
             if ( ! bSeenCR)
             {
                sLastKey = "Enter";
                bSeenCR = true;
             }
             else
             {
                sLastKey = "Enter Twice";
                bSeenCR = false;
             }
             break;

          default :
             sLastKey = Integer.toString(key);
             bSeenCR = false;
             break;

       }  // end switch(key)
       repaint();
       return super.keyDown(evt, key);
    }

    public void paint(Graphics g)
    {
       g.drawString(sLastKey, 1, 10);
    }


    public static void main(String args[])
    {
       // create an instance of your applet class
       Applet a = new KeyDownTest();

       // initialize the applet
       a.init();
       a.start();

       // create new application frame window
       AppletFrame f = new AppletFrame("Key Down Test");

       // add applet to frame window
       f.add("Center", a);

       // resize frame window to fit applet
       // assumes that the applet sets its own size
       // otherwise, you should set a specific size here.
       Dimension s = a.size();
       f.pack();
       f.resize( s );

       // show the window
       f.show();

    }  // end main()

}
