/*
 * @(#)BorderFlowTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

class BorderFlowPanel extends Panel {
  Panel Nb, Sb, Bb;
  Button Eb, Wb;
  BorderLayout b;
  int depth;
  boolean flip;

  public BorderFlowPanel(int i, boolean b) {
    depth = i;
    flip = b;

    if (i == 0) {
      setLayout(new GridLayout(0,1));
      add(new RectFlowPanel());
    } else addBorderComps();
  }


  public boolean action(Event evt, Object arg) {
    if ("Flip".equals(arg))
      if(isBbinNb()) {
	Nb.remove(Bb);
	Sb.add(Bb);
	invalidate();
	validate();
      } else {
	Sb.remove(Bb);
	Nb.add(Bb);
	invalidate();
	validate();
      }
    else if ("Dump".equals(arg)) {
      System.out.println("---- Dump Status ----");
      System.out.println(b.toString());
    } else return false;
    return true;
  }


  private void addBorderComps() {
    b = new BorderLayout();
    setLayout(b);
    Nb = new Panel();
    Sb = new Panel();
    Wb = new Button("Dump");
    Eb = new Button("Flip");
    Bb = ButtonPanel();

    if (flip)
      Nb.add(Bb);
    else Sb.add(Bb);

    add("North", Nb);
    add("South", Sb);
    add("East", Eb);
    add("West", Wb);
    add("Center", new BorderFlowPanel(depth-1, !flip));
  }


  private Panel ButtonPanel() {
    Panel p = new Panel();
    p.setLayout(new FlowLayout());
    p.add(new Button("Inner 1"));
    p.add(new Button("Inner 2"));
    p.add(new Button("Inner 3"));
    p.add(new Button("Inner 4"));
    p.add(new Button("Inner 5"));
    return p;
  }


  private boolean isBbinNb() {
    if (Nb.countComponents() > 0)
      return true;
    return false;
  }
}


class RectFlowPanel extends Panel {

  public void paint(Graphics g) {
    Rectangle r = bounds();
    g.setColor(Color.red);
    g.fill3DRect(0, 0, r.width, r.height, true);
  }
}



public class BorderFlowTest extends TestApplet {

  public void init() {
    setLayout(new GridLayout(0,1));
    add(new BorderFlowPanel(6, true));
  }

  public static void main(String argv[]) {
    Frame f = new Frame("BorderFlowTest");
    BorderFlowTest borderflowtest = new BorderFlowTest();

    borderflowtest.init();
    borderflowtest.start();

    f.resize(200, 200);
    f.add("Center", borderflowtest);
    f.show();
  }
}
