/*
 * @(#)BorderGridTest.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

class BorderGridPanel extends Panel {
  Button Nb, Sb, Wb;
  Panel Eb;
  BorderLayout b;
  int depth;

  public BorderGridPanel(int i) {
    depth = i;

    if (i == 0) {
      setLayout(new GridLayout(0,1));
      add(new RectPanel());
    } else addBorderComps();
  }


  public boolean action(Event evt, Object arg) {
    if ("Add East".equals(arg) && !isEbPresent()) {
      add("East", Eb);
      validate();
    }
    else if ("Remove East".equals(arg) && isEbPresent()) {
      remove(Eb); 
      validate();
    }
    else if ("Dump".equals(arg)) {
      System.out.println("---- Dump Status ----");
      System.out.println(b.toString());
    } else return false;
    return true;
  }


  private void addBorderComps() {
    b = new BorderLayout();
    setLayout(b);
    Nb = new Button("Remove East");
    Sb = new Button("Add East");
    Eb = ButtonPanel();
    Wb = new Button("Dump");

    add("North", Nb);
    add("South", Sb);
    add("East", Eb);
    add("West", Wb);
    add("Center", new BorderGridPanel(depth-1));
  }


  private Panel ButtonPanel() {
    Panel p = new Panel();
    p.setLayout(new GridLayout(5,1));
    p.add(new Button("Inner 1"));
    p.add(new Button("Inner 2"));
    p.add(new Button("Inner 3"));
    p.add(new Button("Inner 4"));
    p.add(new Button("Inner 5"));
    return p;
  }


  private boolean isEbPresent() {
    for(int i = 0; i < countComponents(); i++)
	if (getComponent(i).equals(Eb))
	  return true;
    return false;
  }
}


class RectPanel extends Panel {

  public void paint(Graphics g) {
    Rectangle r = bounds();
    g.setColor(Color.red);
    g.fill3DRect(0, 0, r.width, r.height, true);
  }
}



public class BorderGridTest extends TestApplet {

  public void init() {
    setLayout(new GridLayout(0,1));
    add(new BorderGridPanel(6));
  }

  public static void main(String argv[]) {
    Frame f = new Frame("BorderGridTest");
    BorderGridTest bordergridtest = new BorderGridTest();

    bordergridtest.init();
    bordergridtest.start();

    f.resize(200, 200);
    f.add("Center", bordergridtest);
    f.show();
  }
}
