/*
 * @(#)BorderTest1.java	1.5 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

class BorderPanel extends Panel {
  Button Nb, Sb, Eb, Wb;
  BorderLayout b;
  int depth;

  public BorderPanel(int i) {
    depth = i;

    if (i == 0) {
      setLayout(new GridLayout(0,1));
      add(new Rect1Panel());
    } else addBorderComps();
  }


  private void addBorderComps() {
    b = new BorderLayout();
    setLayout(b);
    Nb = new Button("Remove East");
    Sb = new Button("Add East");
    Eb = new Button("East");
    Wb = new Button("Dump");

    add("North", Nb);
    add("South", Sb);
    add("East", Eb);
    add("West", Wb);
    add("Center", new BorderPanel(depth-1));
  }


  private boolean isEbPresent() {
    for(int i = 0; i < countComponents(); i++)
	if (getComponent(i).equals(Eb))
	  return true;
    return false;
  }


  public boolean action(Event evt, Object arg) {
    if ("Add East".equals(arg))
      if (!isEbPresent()) {
	add("East", Eb);
	validate();
      }
      else return true;
    else if ("Remove East".equals(arg))
      if (isEbPresent()) {
	remove(Eb);
	validate();
      }
      else return true;
    else if ("Dump".equals(arg)) {
      System.out.println("---- Dump Status ----");
      System.out.println(b.toString());
    } else return false;
    return true;
  }
}



class Rect1Panel extends Panel {

  public void paint(Graphics g) {
    Rectangle r = bounds();
    g.setColor(Color.red);
    g.fill3DRect(0, 0, r.width, r.height, true);
  }
}



public class BorderTest1 extends TestApplet {
  BorderPanel borderpanel;

  public void init() {
    setLayout(new GridLayout(0,1));
    add(new BorderPanel(7));
  }

  public static void main(String argv[]) {
    Frame f = new Frame("BorderTest1");
    BorderTest1 bordertest = new BorderTest1();

    bordertest.init();
    bordertest.start();

    f.resize(900, 900);
    f.add("Center", bordertest);
    f.show();
  }
}

    
