/*
 * @(#)ButtonTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


/**
 * An interactive test of Button.enable() and Button.disable()
 *
 * @version 1.0
 * @author Thomas Ball
 */

public class ButtonTest extends TestApplet {
    Panel buttonPanel;

    Button left;
    Button right;
    
    public void init() {
	setLayout(new FlowLayout());
	left = new Button("left");
	add(left);
	right = new Button("right");
	add(right);
    }
    
    public void start() {
	left.enable();
	right.disable();
    }

    public void stop() {
	left.disable();
	right.disable();
    }

    public boolean handleEvent(Event e) {
	Object target = e.target;
	
	switch (e.id) {
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  case Event.ACTION_EVENT:
	    if (target == left) {
		if (!left.isEnabled()) {
		    print("left button failed: disabled, but sending event");
		} else {
		    left.disable();
		    right.enable();
		    invalidate();
		    validate();
		}
		return true;
	    } else if (target == right) {
		if (!right.isEnabled()) {
		    print("right button failed: disabled, but sending event");
		} else {
		    right.disable();
		    left.enable();
		    invalidate();
		    validate();
		}
		return true;
	    }
	  default:
	    return false;
	}
    }

    void dump(String label) {
	print("---------- "+label);
	list();
	print("");
	print("");
    }
	
    public static void main(String args[]) {
	Frame f = new Frame("ButtonTest");
	ButtonTest buttonTest = new ButtonTest();

	buttonTest.init();
	buttonTest.start();

	f.add("Center", buttonTest);
	f.resize(100, 100);
	f.show();
    }
}

