/*
 * @(#)CheckboxGroupTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;


public class CheckboxGroupTest extends TestApplet {
  Panel cbpanel, buttonpanel;
  Checkbox cb1;
  CheckboxGroup cbg;
  TextField tf1, tf2;
  
  public CheckboxGroupTest() {
    cbpanel = new Panel();
    cbg = new CheckboxGroup();
    cbpanel.setLayout(new GridLayout(0,1));
    cbpanel.add(new Checkbox("One", cbg, true));
    cbpanel.add(new Checkbox("Two", cbg, false));
    cbpanel.add(new Checkbox("Three", cbg, false));
    cbpanel.add(new Checkbox("Four", cbg, false));
    cbpanel.add(new Checkbox("Five", cbg, false));
    cbpanel.add(new Checkbox("Six", cbg, false));
    cbpanel.add(new Checkbox("Seven", cbg, false));
    cbpanel.add(new Checkbox("Eight", cbg, false));
    cbpanel.add(new Checkbox("Nine", cbg, false));

    buttonpanel = new Panel();
    buttonpanel.setLayout(new GridLayout(2,2));
    buttonpanel.add(new Button("GetCurrent"));
    buttonpanel.add(new Label("Cur Item:"));
    buttonpanel.add(tf1 = new TextField(6));
    buttonpanel.add(new Button("SetCurrent"));
    buttonpanel.add(new Label("Set Cur:"));
    buttonpanel.add(tf2 = new TextField(8));

    setLayout(new BorderLayout());
    add("North", cbpanel);
    add("South", buttonpanel);
    show();
  }

  public boolean action(Event evt, Object arg) {
    Checkbox comp;
    if (evt.target instanceof Button) {
      if ("GetCurrent".equals(arg))
	tf1.setText(cbg.getCurrent().getLabel());
      else if ("SetCurrent".equals(arg))
	for(int i=0; i<9; i++) {
	  comp = (Checkbox)cbpanel.getComponent(i);
	  if (tf2.getText().equals(comp.getLabel()))
	    cbg.setCurrent(comp);
	}
      else return false;
    } else return false;
    print(cbg.toString());
    return true;
  }
}
