/*
 * @(#)CheckboxTest.java	1.7 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of a Container with Checkboxes.
 */
public class CheckboxTest extends TestApplet {
    Panel p;
    Checkbox cb1, cb2;
    CheckboxGroup g1, g2;

    public void init() {
	p = new Panel();
	g1 = new CheckboxGroup();
	g2 = new CheckboxGroup();
	p.setLayout(new GridLayout(0, 3));

	cb1 = new Checkbox();
	cb1.setLabel("one");
	cb1.setCheckboxGroup(g1);
	cb1.setState(true);
	p.add(cb1);

	cb2 = new Checkbox("een");
	cb2.setCheckboxGroup(g2);
	cb2.setState(true);
	p.add(cb2);

	p.add(new Checkbox("eins", null, true));
	p.add(new Checkbox("two", g1, false));
	p.add(new Checkbox("twee", g2, false));
	p.add(new Checkbox("zwei", null, false));
	p.add(new Checkbox("three", g1, false));
	p.add(new Checkbox("drie", g2, false));
	p.add(new Checkbox("drei", null, false));
	p.add(new Checkbox("four", g1, false));
	p.add(new Checkbox("vier", g2, false));
	p.add(new Checkbox("vier", null, false));
	p.add(new Checkbox("five", g1, false));
	// test setCheckboxGroup()
	Checkbox box = new Checkbox("vijf", null, false);
	p.add(box);
	box.setCheckboxGroup(g2);
	p.add(new Checkbox("fumf", null, false));

	add("Center", p);
	add("South", new Button("list"));
	move(200, 100);
//	pack();
	show();
    }
    
    public void list() {
	String s;
	print("-- list of all check boxes that are turned on --");
	for (int i = 0 ; i < p.countComponents() ; i++) {
	    Checkbox comp = (Checkbox)p.getComponent(i);
	    if (comp.getState()) {
		if (comp.getCheckboxGroup() != null)
		  if (comp.getCheckboxGroup() == g1)
		    s = " - g1";
		  else s = " - g2";
		else s = " - null";
		print(comp.getLabel()+s);
	    }
	}
    }

    public boolean handleEvent(Event evt) {
	if (evt.id == Event.ACTION_EVENT) {
	    if ("list".equals(evt.arg)) {
		list();
	    } else {
		print(evt.toString());
	    }
	    return true;
	}
	return false;
    }

    public static void main(String args[]) {
	Frame f = new Frame("CheckboxTest");
	CheckboxTest checkboxtest = new CheckboxTest();

	checkboxtest.init();
	checkboxtest.start();

	f.resize(200, 200);
	f.add("Center", checkboxtest);
	f.show();
    }
}
