/*
 * @(#)ChoiceTest.java	1.5 96/12/18
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of Choice components.
 */
public class ChoiceTest extends TestApplet {
    Choice c1;
    Choice c2;

    public void init() {
	c1 = new Choice();
	c1.addItem("one");
	c1.addItem("two");
	c1.addItem("three");
	c1.addItem("four");
	c1.insert("one-and-a-half", 1);
	add("North", c1);

	c2 = new Choice();
	c2.addItem("een");
	c2.addItem("twee");
	c2.addItem("drie");
	c2.addItem("vier");
	add("Center", c2);

	add("South", new Button("print"));
	move(200, 100);
//	pack();
	show();
    }

    public boolean action(Event evt, Object arg) {
	if ("print".equals(arg)) {
	    print("-- selected items --");
	    print(c1.getSelectedItem());
	    print(c2.getSelectedItem());
	    return true;
	}
	print(evt.toString());
	return false;
    }

    public static void main(String args[]) {
	Frame f = new Frame("ChoiceTest");
	ChoiceTest choicetest = new ChoiceTest();

	choicetest.init();
	choicetest.start();

	f.resize(200, 200);
	f.add("Center", choicetest);
	f.show();
    }
}
