/*
 * @(#)ChoiceTest1.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of Choice components.
 */
public class ChoiceTest1 extends TestApplet {
    Choice c1;
    Choice c2;

    public void init() {
	c1 = new Choice();
	c1.addItem("one");
	c1.addItem("two");
	c1.addItem("three");
	c1.addItem("four");
	add(c1);

	c2 = new Choice();
	c2.addItem("een");
	c2.addItem("twee");
	c2.addItem("drie");
	c2.addItem("vier");
	add(c2);

	add(new Button("print selected"));
	add(new Button("Dump"));
	resize(200, 100);
//	pack();
	show();
    }

    public boolean action(Event evt, Object arg) {
	if ("print selected".equals(arg)) {
	    print("-- selected items --");
	    print(c1.getSelectedItem());
	    print(c2.getSelectedItem());
	    return true;
	} else if ("Dump".equals(arg)) {
	    print("-- Dump of choice components --");
	    print("countItems(): ");
	    print("   c1: " + c1.countItems());
	    print("   c2: " + c2.countItems());
	    print("");
	    print("c1.getItem(3): " + c1.getItem(3));
	    print("c2.getItem(3): " + c2.getItem(3));
	    print("");
	    print("c1 selected item, index: " + c1.getSelectedItem() + ", " + c1.getSelectedIndex());
	    print("c2 selected item, index: " + c2.getSelectedItem() + ", " + c2.getSelectedIndex());
	    print("");
//	    print("paramString: ");
//	    print("   c1: " + c1.paramString());
//	    print("   c2: " + c2.paramString());
//	    print("");
	    print("c1 - verify selected item: 3");
	    c1.select(3);
	    print("c2 - verify selected string: twee");
	    c2.select("twee");
	    return true;
	}
	print(evt.toString());
	return false;
    }

    public static void main(String args[]) {
	Frame f = new Frame("ChoiceTest1");
	ChoiceTest1 choicetest = new ChoiceTest1();

	choicetest.init();
	choicetest.start();

	f.resize(200, 200);
	f.add("Center", choicetest);
	f.show();
    }
}
